% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_listener}
\alias{elbv2_modify_listener}
\title{Modifies the specified properties of the specified listener}
\usage{
elbv2_modify_listener(ListenerArn, Port, Protocol, SslPolicy,
  Certificates, DefaultActions)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Port}{The port for connections from clients to the load balancer.}

\item{Protocol}{The protocol for connections from clients to the load balancer.
Application Load Balancers support the HTTP and HTTPS protocols. Network
Load Balancers support the TCP and TLS protocols.}

\item{SslPolicy}{[HTTPS and TLS listeners] The security policy that defines which
protocols and ciphers are supported. For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies}{Security Policies}
in the \emph{Application Load Balancers Guide}.}

\item{Certificates}{[HTTPS and TLS listeners] The default SSL server certificate. You must
provide exactly one certificate. Set \code{CertificateArn} to the certificate
ARN but do not set \code{IsDefault}.

To create a certificate list, use AddListenerCertificates.}

\item{DefaultActions}{The actions for the default rule. The rule must include one forward
action or one or more fixed-response actions.

If the action type is \code{forward}, you specify a target group. The
protocol of the target group must be HTTP or HTTPS for an Application
Load Balancer. The protocol of the target group must be TCP or TLS for a
Network Load Balancer.

[HTTPS listeners] If the action type is \code{authenticate-oidc}, you
authenticate users through an identity provider that is OpenID Connect
(OIDC) compliant.

[HTTPS listeners] If the action type is \code{authenticate-cognito}, you
authenticate users through the user pools supported by Amazon Cognito.

[Application Load Balancer] If the action type is \code{redirect}, you
redirect specified client requests from one URL to another.

[Application Load Balancer] If the action type is \code{fixed-response},
you drop specified client requests and return a custom HTTP response.}
}
\description{
Modifies the specified properties of the specified listener.
}
\details{
Any properties that you do not specify retain their current values.
However, changing the protocol from HTTPS to HTTP, or from TLS to TCP,
removes the security policy and server certificate properties. If you
change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add
the security policy and server certificate properties.
}
\section{Request syntax}{
\preformatted{svc$modify_listener(
  ListenerArn = "string",
  Port = 123,
  Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS",
  SslPolicy = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  ),
  DefaultActions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      )
    )
  )
)
}
}

\examples{
# This example changes the default action for the specified listener.
\donttest{svc$modify_listener(
  DefaultActions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-n...",
      Type = "forward"
    )
  ),
  ListenerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-ba..."
)}

# This example changes the server certificate for the specified HTTPS
# listener.
\donttest{svc$modify_listener(
  Certificates = list(
    list(
      CertificateArn = "arn:aws:iam::123456789012:server-certificate/my-new-server-cert"
    )
  ),
  ListenerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-ba..."
)}

}
\keyword{internal}
