% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_analyze_document}
\alias{textract_analyze_document}
\title{Analyzes an input document for relationships between detected items}
\usage{
textract_analyze_document(
  Document,
  FeatureTypes,
  HumanLoopConfig = NULL,
  QueriesConfig = NULL
)
}
\arguments{
\item{Document}{[required] The input document as base64-encoded bytes or an Amazon S3 object. If
you use the AWS CLI to call Amazon Textract operations, you can't pass
image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
format.

If you're using an AWS SDK to call Amazon Textract, you might not need
to base64-encode image bytes that are passed using the \code{Bytes} field.}

\item{FeatureTypes}{[required] A list of the types of analysis to perform. Add TABLES to the list to
return information about the tables that are detected in the input
document. Add FORMS to return detected form data. Add SIGNATURES to
return the locations of detected signatures. To perform both forms and
table analysis, add TABLES and FORMS to \code{FeatureTypes}. To detect
signatures within form data and table data, add SIGNATURES to either
TABLES or FORMS. All lines and words detected in the document are
included in the response (including text that isn't related to the value
of \code{FeatureTypes}).}

\item{HumanLoopConfig}{Sets the configuration for the human in the loop workflow for analyzing
documents.}

\item{QueriesConfig}{Contains Queries and the alias for those Queries, as determined by the
input.}
}
\description{
Analyzes an input document for relationships between detected items.

See \url{https://www.paws-r-sdk.com/docs/textract_analyze_document/} for full documentation.
}
\keyword{internal}
