% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voiceid_operations.R
\name{voiceid_create_domain}
\alias{voiceid_create_domain}
\title{Creates a domain that contains all Amazon Connect Voice ID data, such as
speakers, fraudsters, customer audio, and voiceprints}
\usage{
voiceid_create_domain(
  ClientToken = NULL,
  Description = NULL,
  Name,
  ServerSideEncryptionConfiguration,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{The idempotency token for creating a new domain. If not provided, Amazon
Web Services SDK populates this field.}

\item{Description}{A brief description of this domain.}

\item{Name}{[required] The name of the domain.}

\item{ServerSideEncryptionConfiguration}{[required] The configuration, containing the KMS key identifier, to be used by
Voice ID for the server-side encryption of your data. Refer to \href{https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid}{Amazon Connect Voice ID encryption at rest}
for more details on how the KMS key is used.}

\item{Tags}{A list of tags you want added to the domain.}
}
\description{
Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints.

See \url{https://paws-r.github.io/docs/voiceid/create_domain.html} for full documentation.
}
\keyword{internal}
