% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_compare_faces}
\alias{rekognition_compare_faces}
\title{Compares a face in the source input image with each of the 100 largest
faces detected in the target input image}
\usage{
rekognition_compare_faces(
  SourceImage,
  TargetImage,
  SimilarityThreshold = NULL,
  QualityFilter = NULL
)
}
\arguments{
\item{SourceImage}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{TargetImage}{[required] The target image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{SimilarityThreshold}{The minimum level of confidence in the face matches that a match must
meet to be included in the \code{FaceMatches} array.}

\item{QualityFilter}{A filter that specifies a quality bar for how much filtering is done to
identify faces. Filtered faces aren't compared. If you specify \code{AUTO},
Amazon Rekognition chooses the quality bar. If you specify \code{LOW},
\code{MEDIUM}, or \code{HIGH}, filtering removes all faces that don’t meet the
chosen quality bar. The quality bar is based on a variety of common use
cases. Low-quality detections can occur for a number of reasons. Some
examples are an object that's misidentified as a face, a face that's too
blurry, or a face with a pose that's too extreme to use. If you specify
\code{NONE}, no filtering is performed. The default value is \code{NONE}.

To use quality filtering, the collection you are using must be
associated with version 3 of the face model or higher.}
}
\description{
Compares a face in the \emph{source} input image with each of the 100 largest faces detected in the \emph{target} input image.

See \url{https://paws-r.github.io/docs/rekognition/compare_faces.html} for full documentation.
}
\keyword{internal}
