% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_entity_recognizer}
\alias{comprehend_create_entity_recognizer}
\title{Creates an entity recognizer using submitted files}
\usage{
comprehend_create_entity_recognizer(
  RecognizerName,
  VersionName = NULL,
  DataAccessRoleArn,
  Tags = NULL,
  InputDataConfig,
  ClientRequestToken = NULL,
  LanguageCode,
  VolumeKmsKeyId = NULL,
  VpcConfig = NULL,
  ModelKmsKeyId = NULL,
  ModelPolicy = NULL
)
}
\arguments{
\item{RecognizerName}{[required] The name given to the newly created recognizer. Recognizer names can be
a maximum of 256 characters. Alphanumeric characters, hyphens (-) and
underscores (_) are allowed. The name must be unique in the
account/region.}

\item{VersionName}{The version name given to the newly created recognizer. Version names
can be a maximum of 256 characters. Alphanumeric characters, hyphens (-)
and underscores (_) are allowed. The version name must be unique among
all models with the same recognizer name in the account/ AWS Region.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
role that grants Amazon Comprehend read access to your input data.}

\item{Tags}{Tags to be associated with the entity recognizer being created. A tag is
a key-value pair that adds as a metadata to a resource used by Amazon
Comprehend. For example, a tag with "Sales" as the key might be added to
a resource to indicate its use by the sales department.}

\item{InputDataConfig}{[required] Specifies the format and location of the input data. The S3 bucket
containing the input data must be located in the same region as the
entity recognizer being created.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{LanguageCode}{[required] You can specify any of the following languages supported by Amazon
Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian
("it"), German ("de"), or Portuguese ("pt"). All documents must be in
the same language.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{Configuration parameters for an optional private Virtual Private Cloud
(VPC) containing the resources you are using for your custom entity
recognizer. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html}{Amazon VPC}.}

\item{ModelKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt trained custom models. The ModelKmsKeyId can be either
of the following formats
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{ModelPolicy}{The JSON resource-based policy to attach to your custom entity
recognizer model. You can use this policy to allow another AWS account
to import your custom model.

Provide your JSON as a UTF-8 encoded string without line breaks. To
provide valid JSON for your policy, enclose the attribute names and
values in double quotes. If the JSON body is also enclosed in double
quotes, then you must escape the double quotes that are inside the
policy:

\verb{"\{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]\}"}

To avoid escaping quotes, you can use single quotes to enclose the
policy and double quotes to enclose the JSON names and values:

\code{'{"attribute": "value", "attribute": ["value"]}'}}
}
\description{
Creates an entity recognizer using submitted files. After your \code{\link[=comprehend_create_entity_recognizer]{create_entity_recognizer}} request is submitted, you can check job status using the API.

See \url{https://paws-r.github.io/docs/comprehend/create_entity_recognizer.html} for full documentation.
}
\keyword{internal}
