% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerruntime_operations.R
\name{sagemakerruntime_invoke_endpoint}
\alias{sagemakerruntime_invoke_endpoint}
\title{After you deploy a model into production using Amazon SageMaker hosting
services, your client applications use this API to get inferences from
the model hosted at the specified endpoint}
\usage{
sagemakerruntime_invoke_endpoint(EndpointName, Body, ContentType,
  Accept, CustomAttributes, TargetModel, TargetVariant)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint that you specified when you created the
endpoint using the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html}{CreateEndpoint}
API.}

\item{Body}{[required] Provides input data, in the format specified in the \code{ContentType}
request header. Amazon SageMaker passes all of the data in the body to
the model.

For information about the format of the request body, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html}{Common Data Formats-Inference}.}

\item{ContentType}{The MIME type of the input data in the request body.}

\item{Accept}{The desired MIME type of the inference in the response.}

\item{CustomAttributes}{Provides additional information about a request for an inference
submitted to a model hosted at an Amazon SageMaker endpoint. The
information is an opaque value that is forwarded verbatim. You could use
this value, for example, to provide an ID that you can use to track a
request or to provide other metadata that a service endpoint was
programmed to process. The value must consist of no more than 1024
visible US-ASCII characters as specified in \href{https://tools.ietf.org/html/rfc7230#section-3.2.6}{Section 3.3.6. Field Value Components} of the
Hypertext Transfer Protocol (HTTP/1.1). This feature is currently
supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.}

\item{TargetModel}{The model to request for inference when invoking a multi-model endpoint.}

\item{TargetVariant}{Specify the production variant to send the inference request to when
invoking an endpoint that is running two or more variants. Note that
this parameter overrides the default behavior for the endpoint, which is
to distribute the invocation traffic based on the variant weights.}
}
\description{
After you deploy a model into production using Amazon SageMaker hosting
services, your client applications use this API to get inferences from
the model hosted at the specified endpoint.
}
\details{
For an overview of Amazon SageMaker, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html}{How It Works}.

Amazon SageMaker strips all POST headers except those supported by the
API. Amazon SageMaker might add additional headers. You should not rely
on the behavior of headers outside those enumerated in the request
syntax.

Calls to \code{InvokeEndpoint} are authenticated by using AWS Signature
Version 4. For information, see \href{http://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html}{Authenticating Requests (AWS Signature Version 4)}
in the \emph{Amazon S3 API Reference}.

A customer\'s model containers must respond to requests within 60
seconds. The model itself can have a maximum processing time of 60
seconds before responding to the /invocations. If your model is going to
take 50-60 seconds of processing time, the SDK socket timeout should be
set to be 70 seconds.

Endpoints are scoped to an individual account, and are not public. The
URL does not contain the account ID, but Amazon SageMaker determines the
account ID from the authentication token that is supplied by the caller.
}
\section{Request syntax}{
\preformatted{svc$invoke_endpoint(
  EndpointName = "string",
  Body = raw,
  ContentType = "string",
  Accept = "string",
  CustomAttributes = "string",
  TargetModel = "string",
  TargetVariant = "string"
)
}
}

\keyword{internal}
