% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_endpoint}
\alias{sagemaker_update_endpoint}
\title{Deploys the new EndpointConfig specified in the request, switches to
using newly created endpoint, and then deletes resources provisioned for
the endpoint using the previous EndpointConfig (there is no availability
loss)}
\usage{
sagemaker_update_endpoint(EndpointName, EndpointConfigName)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint whose configuration you want to update.}

\item{EndpointConfigName}{[required] The name of the new endpoint configuration.}
}
\description{
Deploys the new \code{EndpointConfig} specified in the request, switches to
using newly created endpoint, and then deletes resources provisioned for
the endpoint using the previous \code{EndpointConfig} (there is no
availability loss).
}
\details{
When Amazon SageMaker receives the request, it sets the endpoint status
to \code{Updating}. After updating the endpoint, it sets the status to
\code{InService}. To check the status of an endpoint, use the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html}{DescribeEndpoint}
API.

You must not delete an \code{EndpointConfig} in use by an endpoint that is
live or while the \code{UpdateEndpoint} or \code{CreateEndpoint} operations are
being performed on the endpoint. To update an endpoint, you must create
a new \code{EndpointConfig}.
}
\section{Request syntax}{
\preformatted{svc$update_endpoint(
  EndpointName = "string",
  EndpointConfigName = "string"
)
}
}

\keyword{internal}
