% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_describe_campaign}
\alias{personalize_describe_campaign}
\title{Describes the given campaign, including its status}
\usage{
personalize_describe_campaign(campaignArn)
}
\arguments{
\item{campaignArn}{[required] The Amazon Resource Name (ARN) of the campaign.}
}
\description{
Describes the given campaign, including its status.
}
\details{
A campaign can be in one of the following states:
\itemize{
\item CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
\item DELETE PENDING \\> DELETE IN\\_PROGRESS
}

When the \code{status} is \verb{CREATE FAILED}, the response includes the
\code{failureReason} key, which describes why.

For more information on campaigns, see CreateCampaign.
}
\section{Request syntax}{
\preformatted{svc$describe_campaign(
  campaignArn = "string"
)
}
}

\keyword{internal}
