% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_start_document_analysis}
\alias{textract_start_document_analysis}
\title{Starts asynchronous analysis of an input document for relationships
between detected items such as key and value pairs, tables, and
selection elements}
\usage{
textract_start_document_analysis(DocumentLocation, FeatureTypes,
  ClientRequestToken, JobTag, NotificationChannel)
}
\arguments{
\item{DocumentLocation}{[required] The location of the document to be processed.}

\item{FeatureTypes}{[required] A list of the types of analysis to perform. Add TABLES to the list to
return information about the tables that are detected in the input
document. Add FORMS to return detected fields and the associated text.
To perform both types of analysis, add TABLES and FORMS to
\code{FeatureTypes}. All selectable elements (\code{SELECTION_ELEMENT}) that are
detected are returned, whatever the value of \code{FeatureTypes}.}

\item{ClientRequestToken}{The idempotent token that you use to identify the start request. If you
use the same token with multiple \code{StartDocumentAnalysis} requests, the
same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the same
job from being accidentally started more than once.}

\item{JobTag}{An identifier you specify that's included in the completion
notification that's published to the Amazon SNS topic. For example, you
can use \code{JobTag} to identify the type of document, such as a tax form or
a receipt, that the completion notification corresponds to.}

\item{NotificationChannel}{The Amazon SNS topic ARN that you want Amazon Textract to publish the
completion status of the operation to.}
}
\description{
Starts asynchronous analysis of an input document for relationships
between detected items such as key and value pairs, tables, and
selection elements.
}
\details{
\code{StartDocumentAnalysis} can analyze text in documents that are in JPG,
PNG, and PDF format. The documents are stored in an Amazon S3 bucket.
Use DocumentLocation to specify the bucket name and file name of the
document.

\code{StartDocumentAnalysis} returns a job identifier (\code{JobId}) that you use
to get the results of the operation. When text analysis is finished,
Amazon Textract publishes a completion status to the Amazon Simple
Notification Service (Amazon SNS) topic that you specify in
\code{NotificationChannel}. To get the results of the text analysis
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call GetDocumentAnalysis, and pass the job
identifier (\code{JobId}) from the initial call to \code{StartDocumentAnalysis}.

For more information, see \href{https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html}{Document Text Analysis}.
}
\section{Request syntax}{
\preformatted{svc$start_document_analysis(
  DocumentLocation = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  FeatureTypes = list(
    "TABLES"|"FORMS"
  ),
  ClientRequestToken = "string",
  JobTag = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  )
)
}
}

\keyword{internal}
