# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Textract
#'
#' @description
#' Amazon Textract detects and analyzes text in documents and converts it
#' into machine-readable text. This is the API reference documentation for
#' Amazon Textract.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- textract(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- textract()
#' svc$analyze_document(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=textract_analyze_document]{analyze_document} \tab Analyzes an input document for relationships between detected items \cr
#'  \link[=textract_detect_document_text]{detect_document_text} \tab Detects text in the input document \cr
#'  \link[=textract_get_document_analysis]{get_document_analysis} \tab Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document \cr
#'  \link[=textract_get_document_text_detection]{get_document_text_detection} \tab Gets the results for an Amazon Textract asynchronous operation that detects text in a document \cr
#'  \link[=textract_start_document_analysis]{start_document_analysis} \tab Starts asynchronous analysis of an input document for relationships between detected items such as key and value pairs, tables, and selection elements\cr
#'  \link[=textract_start_document_text_detection]{start_document_text_detection} \tab Starts the asynchronous detection of text in a document 
#' }
#'
#' @rdname textract
#' @export
textract <- function(config = list()) {
  svc <- .textract$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.textract <- list()

.textract$operations <- list()

.textract$metadata <- list(
  service_name = "textract",
  endpoints = list("*" = list(endpoint = "textract.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "textract.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Textract",
  api_version = "2018-06-27",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "Textract"
)

.textract$handlers <- new_handlers("jsonrpc", "v4")

.textract$service <- function(config = list()) {
  new_service(.textract$metadata, .textract$handlers, config)
}
