# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Personalize Runtime
#'
#' 
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- personalizeruntime(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- personalizeruntime()
#' svc$get_personalized_ranking(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=personalizeruntime_get_personalized_ranking]{get_personalized_ranking} \tab Re-ranks a list of recommended items for the given user\cr
#'  \link[=personalizeruntime_get_recommendations]{get_recommendations} \tab Returns a list of recommended items
#' }
#'
#' @rdname personalizeruntime
#' @export
personalizeruntime <- function(config = list()) {
  svc <- .personalizeruntime$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.personalizeruntime <- list()

.personalizeruntime$operations <- list()

.personalizeruntime$metadata <- list(
  service_name = "personalizeruntime",
  endpoints = list("*" = list(endpoint = "personalizeruntime.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "personalizeruntime.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "personalizeruntime.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "personalizeruntime.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Personalize Runtime",
  api_version = "2018-05-22",
  signing_name = "personalize",
  json_version = "1.1",
  target_prefix = ""
)

.personalizeruntime$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.personalizeruntime$metadata, handlers, config)
}
