% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_disassociate_delegate_from_resource}
\alias{workmail_disassociate_delegate_from_resource}
\title{Removes a member from the resource's set of delegates}
\usage{
workmail_disassociate_delegate_from_resource(
  OrganizationId,
  ResourceId,
  EntityId
)
}
\arguments{
\item{OrganizationId}{[required] The identifier for the organization under which the resource exists.}

\item{ResourceId}{[required] The identifier of the resource from which delegates' set members are
removed.

The identifier can accept \emph{ResourceId}, \emph{Resourcename}, or \emph{email}. The
following identity formats are available:
\itemize{
\item Resource ID: r-0123456789a0123456789b0123456789
\item Email address: resource@domain.tld
\item Resource name: resource
}}

\item{EntityId}{[required] The identifier for the member (user, group) to be removed from the
resource's delegates.

The entity ID can accept \emph{UserId or GroupID}, \emph{Username or Groupname},
or \emph{email}.
\itemize{
\item Entity: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: entity@domain.tld
\item Entity: entity
}}
}
\description{
Removes a member from the resource's set of delegates.

See \url{https://www.paws-r-sdk.com/docs/workmail_disassociate_delegate_from_resource/} for full documentation.
}
\keyword{internal}
