% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_merge_pull_request_by_three_way}
\alias{codecommit_merge_pull_request_by_three_way}
\title{Attempts to merge the source commit of a pull request into the specified
destination branch for that pull request at the specified commit using
the three-way merge strategy}
\usage{
codecommit_merge_pull_request_by_three_way(pullRequestId,
  repositoryName, sourceCommitId, conflictDetailLevel,
  conflictResolutionStrategy, commitMessage, authorName, email,
  keepEmptyFolders, conflictResolution)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{repositoryName}{[required] The name of the repository where the pull request was created.}

\item{sourceCommitId}{The full commit ID of the original or updated commit in the pull request
source branch. Pass this value if you want an exception thrown if the
current commit ID of the tip of the source branch does not match this
commit ID.}

\item{conflictDetailLevel}{The level of conflict detail to use. If unspecified, the default
FILE_LEVEL is used, which returns a not-mergeable result if the same
file has differences in both branches. If LINE_LEVEL is specified, a
conflict is considered not mergeable if the same file in both branches
has differences on the same line.}

\item{conflictResolutionStrategy}{Specifies which branch to use when resolving conflicts, or whether to
attempt automatically merging two versions of a file. The default is
NONE, which requires any conflicts to be resolved manually before the
merge operation is successful.}

\item{commitMessage}{The commit message to include in the commit information for the merge.}

\item{authorName}{The name of the author who created the commit. This information is used
as both the author and committer for the commit.}

\item{email}{The email address of the person merging the branches. This information
is used in the commit information for the merge.}

\item{keepEmptyFolders}{If the commit contains deletions, whether to keep a folder or folder
structure if the changes leave the folders empty. If true, a .gitkeep
file is created for empty folders. The default is false.}

\item{conflictResolution}{If AUTOMERGE is the conflict resolution strategy, a list of inputs to
use when resolving conflicts during a merge.}
}
\value{
A list with the following syntax:\preformatted{list(
  pullRequest = list(
    pullRequestId = "string",
    title = "string",
    description = "string",
    lastActivityDate = as.POSIXct(
      "2015-01-01"
    ),
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    pullRequestStatus = "OPEN"|"CLOSED",
    authorArn = "string",
    pullRequestTargets = list(
      list(
        repositoryName = "string",
        sourceReference = "string",
        destinationReference = "string",
        destinationCommit = "string",
        sourceCommit = "string",
        mergeBase = "string",
        mergeMetadata = list(
          isMerged = TRUE|FALSE,
          mergedBy = "string",
          mergeCommitId = "string",
          mergeOption = "FAST_FORWARD_MERGE"|"SQUASH_MERGE"|"THREE_WAY_MERGE"
        )
      )
    ),
    clientRequestToken = "string",
    revisionId = "string",
    approvalRules = list(
      list(
        approvalRuleId = "string",
        approvalRuleName = "string",
        approvalRuleContent = "string",
        ruleContentSha256 = "string",
        lastModifiedDate = as.POSIXct(
          "2015-01-01"
        ),
        creationDate = as.POSIXct(
          "2015-01-01"
        ),
        lastModifiedUser = "string",
        originApprovalRuleTemplate = list(
          approvalRuleTemplateId = "string",
          approvalRuleTemplateName = "string"
        )
      )
    )
  )
)
}
}
\description{
Attempts to merge the source commit of a pull request into the specified
destination branch for that pull request at the specified commit using
the three-way merge strategy. If the merge is successful, it closes the
pull request.
}
\section{Request syntax}{
\preformatted{svc$merge_pull_request_by_three_way(
  pullRequestId = "string",
  repositoryName = "string",
  sourceCommitId = "string",
  conflictDetailLevel = "FILE_LEVEL"|"LINE_LEVEL",
  conflictResolutionStrategy = "NONE"|"ACCEPT_SOURCE"|"ACCEPT_DESTINATION"|"AUTOMERGE",
  commitMessage = "string",
  authorName = "string",
  email = "string",
  keepEmptyFolders = TRUE|FALSE,
  conflictResolution = list(
    replaceContents = list(
      list(
        filePath = "string",
        replacementType = "KEEP_BASE"|"KEEP_SOURCE"|"KEEP_DESTINATION"|"USE_NEW_CONTENT",
        content = raw,
        fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
      )
    ),
    deleteFiles = list(
      list(
        filePath = "string"
      )
    ),
    setFileModes = list(
      list(
        filePath = "string",
        fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
      )
    )
  )
)
}
}

\keyword{internal}
