% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_list_repositories}
\alias{codecommit_list_repositories}
\title{Gets information about one or more repositories}
\usage{
codecommit_list_repositories(nextToken, sortBy, order)
}
\arguments{
\item{nextToken}{An enumeration token that allows the operation to batch the results of
the operation. Batch sizes are 1,000 for list repository operations.
When the client sends the token back to AWS CodeCommit, another page of
1,000 records is retrieved.}

\item{sortBy}{The criteria used to sort the results of a list repositories operation.}

\item{order}{The order in which to sort the results of a list repositories operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  repositories = list(
    list(
      repositoryName = "string",
      repositoryId = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Gets information about one or more repositories.
}
\section{Request syntax}{
\preformatted{svc$list_repositories(
  nextToken = "string",
  sortBy = "repositoryName"|"lastModifiedDate",
  order = "ascending"|"descending"
)
}
}

\keyword{internal}
