# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codestar_service.R
NULL

#' Adds an IAM user to the team for an AWS CodeStar project
#'
#' @description
#' Adds an IAM user to the team for an AWS CodeStar project.
#'
#' @usage
#' codestar_associate_team_member(projectId, clientRequestToken, userArn,
#'   projectRole, remoteAccessAllowed)
#'
#' @param projectId &#91;required&#93; The ID of the project to which you will add the IAM user.
#' @param clientRequestToken A user- or system-generated token that identifies the entity that
#' requested the team member association to the project. This token can be
#' used to repeat the request.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) for the IAM user you want to add to the
#' AWS CodeStar project.
#' @param projectRole &#91;required&#93; The AWS CodeStar project role that will apply to this user. This role
#' determines what actions a user can take in an AWS CodeStar project.
#' @param remoteAccessAllowed Whether the team member is allowed to use an SSH public/private key pair
#' to remotely access project resources, for example Amazon EC2 instances.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_team_member(
#'   projectId = "string",
#'   clientRequestToken = "string",
#'   userArn = "string",
#'   projectRole = "string",
#'   remoteAccessAllowed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_associate_team_member
codestar_associate_team_member <- function(projectId, clientRequestToken = NULL, userArn, projectRole, remoteAccessAllowed = NULL) {
  op <- new_operation(
    name = "AssociateTeamMember",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$associate_team_member_input(projectId = projectId, clientRequestToken = clientRequestToken, userArn = userArn, projectRole = projectRole, remoteAccessAllowed = remoteAccessAllowed)
  output <- .codestar$associate_team_member_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$associate_team_member <- codestar_associate_team_member

#' Creates a project, including project resources
#'
#' @description
#' Creates a project, including project resources. This action creates a
#' project based on a submitted project request. A set of source code files
#' and a toolchain template file can be included with the project request.
#' If these are not provided, an empty project is created.
#'
#' @usage
#' codestar_create_project(name, id, description, clientRequestToken,
#'   sourceCode, toolchain, tags)
#'
#' @param name &#91;required&#93; The display name for the project to be created in AWS CodeStar.
#' @param id &#91;required&#93; The ID of the project to be created in AWS CodeStar.
#' @param description The description of the project, if any.
#' @param clientRequestToken A user- or system-generated token that identifies the entity that
#' requested project creation. This token can be used to repeat the
#' request.
#' @param sourceCode A list of the Code objects submitted with the project request. If this
#' parameter is specified, the request must also include the toolchain
#' parameter.
#' @param toolchain The name of the toolchain template file submitted with the project
#' request. If this parameter is specified, the request must also include
#' the sourceCode parameter.
#' @param tags The tags created for the project.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   id = "string",
#'   arn = "string",
#'   clientRequestToken = "string",
#'   projectTemplateId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_project(
#'   name = "string",
#'   id = "string",
#'   description = "string",
#'   clientRequestToken = "string",
#'   sourceCode = list(
#'     list(
#'       source = list(
#'         s3 = list(
#'           bucketName = "string",
#'           bucketKey = "string"
#'         )
#'       ),
#'       destination = list(
#'         codeCommit = list(
#'           name = "string"
#'         ),
#'         gitHub = list(
#'           name = "string",
#'           description = "string",
#'           type = "string",
#'           owner = "string",
#'           privateRepository = TRUE|FALSE,
#'           issuesEnabled = TRUE|FALSE,
#'           token = "string"
#'         )
#'       )
#'     )
#'   ),
#'   toolchain = list(
#'     source = list(
#'       s3 = list(
#'         bucketName = "string",
#'         bucketKey = "string"
#'       )
#'     ),
#'     roleArn = "string",
#'     stackParameters = list(
#'       "string"
#'     )
#'   ),
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_create_project
codestar_create_project <- function(name, id, description = NULL, clientRequestToken = NULL, sourceCode = NULL, toolchain = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$create_project_input(name = name, id = id, description = description, clientRequestToken = clientRequestToken, sourceCode = sourceCode, toolchain = toolchain, tags = tags)
  output <- .codestar$create_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$create_project <- codestar_create_project

#' Creates a profile for a user that includes user preferences, such as the
#' display name and email address assocciated with the user, in AWS
#' CodeStar
#'
#' @description
#' Creates a profile for a user that includes user preferences, such as the
#' display name and email address assocciated with the user, in AWS
#' CodeStar. The user profile is not project-specific. Information in the
#' user profile is displayed wherever the user's information appears to
#' other users in AWS CodeStar.
#'
#' @usage
#' codestar_create_user_profile(userArn, displayName, emailAddress,
#'   sshPublicKey)
#'
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the user in IAM.
#' @param displayName &#91;required&#93; The name that will be displayed as the friendly name for the user in AWS
#' CodeStar.
#' @param emailAddress &#91;required&#93; The email address that will be displayed as part of the user's profile
#' in AWS CodeStar.
#' @param sshPublicKey The SSH public key associated with the user in AWS CodeStar. If a
#' project owner allows the user remote access to project resources, this
#' public key will be used along with the user's private key for SSH
#' access.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userArn = "string",
#'   displayName = "string",
#'   emailAddress = "string",
#'   sshPublicKey = "string",
#'   createdTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   lastModifiedTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_user_profile(
#'   userArn = "string",
#'   displayName = "string",
#'   emailAddress = "string",
#'   sshPublicKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_create_user_profile
codestar_create_user_profile <- function(userArn, displayName, emailAddress, sshPublicKey = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$create_user_profile_input(userArn = userArn, displayName = displayName, emailAddress = emailAddress, sshPublicKey = sshPublicKey)
  output <- .codestar$create_user_profile_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$create_user_profile <- codestar_create_user_profile

#' Deletes a project, including project resources
#'
#' @description
#' Deletes a project, including project resources. Does not delete users
#' associated with the project, but does delete the IAM roles that allowed
#' access to the project.
#'
#' @usage
#' codestar_delete_project(id, clientRequestToken, deleteStack)
#'
#' @param id &#91;required&#93; The ID of the project to be deleted in AWS CodeStar.
#' @param clientRequestToken A user- or system-generated token that identifies the entity that
#' requested project deletion. This token can be used to repeat the
#' request.
#' @param deleteStack Whether to send a delete request for the primary stack in AWS
#' CloudFormation originally used to generate the project and its
#' resources. This option will delete all AWS resources for the project
#' (except for any buckets in Amazon S3) as well as deleting the project
#' itself. Recommended for most use cases.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   stackId = "string",
#'   projectArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_project(
#'   id = "string",
#'   clientRequestToken = "string",
#'   deleteStack = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_delete_project
codestar_delete_project <- function(id, clientRequestToken = NULL, deleteStack = NULL) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$delete_project_input(id = id, clientRequestToken = clientRequestToken, deleteStack = deleteStack)
  output <- .codestar$delete_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$delete_project <- codestar_delete_project

#' Deletes a user profile in AWS CodeStar, including all personal
#' preference data associated with that profile, such as display name and
#' email address
#'
#' @description
#' Deletes a user profile in AWS CodeStar, including all personal
#' preference data associated with that profile, such as display name and
#' email address. It does not delete the history of that user, for example
#' the history of commits made by that user.
#'
#' @usage
#' codestar_delete_user_profile(userArn)
#'
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_profile(
#'   userArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_delete_user_profile
codestar_delete_user_profile <- function(userArn) {
  op <- new_operation(
    name = "DeleteUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$delete_user_profile_input(userArn = userArn)
  output <- .codestar$delete_user_profile_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$delete_user_profile <- codestar_delete_user_profile

#' Describes a project and its resources
#'
#' @description
#' Describes a project and its resources.
#'
#' @usage
#' codestar_describe_project(id)
#'
#' @param id &#91;required&#93; The ID of the project.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   id = "string",
#'   arn = "string",
#'   description = "string",
#'   clientRequestToken = "string",
#'   createdTimeStamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   stackId = "string",
#'   projectTemplateId = "string",
#'   status = list(
#'     state = "string",
#'     reason = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_project(
#'   id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_describe_project
codestar_describe_project <- function(id) {
  op <- new_operation(
    name = "DescribeProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$describe_project_input(id = id)
  output <- .codestar$describe_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$describe_project <- codestar_describe_project

#' Describes a user in AWS CodeStar and the user attributes across all
#' projects
#'
#' @description
#' Describes a user in AWS CodeStar and the user attributes across all
#' projects.
#'
#' @usage
#' codestar_describe_user_profile(userArn)
#'
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the user.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userArn = "string",
#'   displayName = "string",
#'   emailAddress = "string",
#'   sshPublicKey = "string",
#'   createdTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   lastModifiedTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_profile(
#'   userArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_describe_user_profile
codestar_describe_user_profile <- function(userArn) {
  op <- new_operation(
    name = "DescribeUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$describe_user_profile_input(userArn = userArn)
  output <- .codestar$describe_user_profile_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$describe_user_profile <- codestar_describe_user_profile

#' Removes a user from a project
#'
#' @description
#' Removes a user from a project. Removing a user from a project also
#' removes the IAM policies from that user that allowed access to the
#' project and its resources. Disassociating a team member does not remove
#' that user's profile from AWS CodeStar. It does not remove the user from
#' IAM.
#'
#' @usage
#' codestar_disassociate_team_member(projectId, userArn)
#'
#' @param projectId &#91;required&#93; The ID of the AWS CodeStar project from which you want to remove a team
#' member.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM user or group whom you want to
#' remove from the project.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_team_member(
#'   projectId = "string",
#'   userArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_disassociate_team_member
codestar_disassociate_team_member <- function(projectId, userArn) {
  op <- new_operation(
    name = "DisassociateTeamMember",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$disassociate_team_member_input(projectId = projectId, userArn = userArn)
  output <- .codestar$disassociate_team_member_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$disassociate_team_member <- codestar_disassociate_team_member

#' Lists all projects in AWS CodeStar associated with your AWS account
#'
#' @description
#' Lists all projects in AWS CodeStar associated with your AWS account.
#'
#' @usage
#' codestar_list_projects(nextToken, maxResults)
#'
#' @param nextToken The continuation token to be used to return the next set of results, if
#' the results cannot be returned in one response.
#' @param maxResults The maximum amount of data that can be contained in a single set of
#' results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   projects = list(
#'     list(
#'       projectId = "string",
#'       projectArn = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_projects(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_list_projects
codestar_list_projects <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$list_projects_input(nextToken = nextToken, maxResults = maxResults)
  output <- .codestar$list_projects_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$list_projects <- codestar_list_projects

#' Lists resources associated with a project in AWS CodeStar
#'
#' @description
#' Lists resources associated with a project in AWS CodeStar.
#'
#' @usage
#' codestar_list_resources(projectId, nextToken, maxResults)
#'
#' @param projectId &#91;required&#93; The ID of the project.
#' @param nextToken The continuation token for the next set of results, if the results
#' cannot be returned in one response.
#' @param maxResults The maximum amount of data that can be contained in a single set of
#' results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   resources = list(
#'     list(
#'       id = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_resources(
#'   projectId = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_list_resources
codestar_list_resources <- function(projectId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$list_resources_input(projectId = projectId, nextToken = nextToken, maxResults = maxResults)
  output <- .codestar$list_resources_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$list_resources <- codestar_list_resources

#' Gets the tags for a project
#'
#' @description
#' Gets the tags for a project.
#'
#' @usage
#' codestar_list_tags_for_project(id, nextToken, maxResults)
#'
#' @param id &#91;required&#93; The ID of the project to get tags for.
#' @param nextToken Reserved for future use.
#' @param maxResults Reserved for future use.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tags = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_project(
#'   id = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_list_tags_for_project
codestar_list_tags_for_project <- function(id, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$list_tags_for_project_input(id = id, nextToken = nextToken, maxResults = maxResults)
  output <- .codestar$list_tags_for_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$list_tags_for_project <- codestar_list_tags_for_project

#' Lists all team members associated with a project
#'
#' @description
#' Lists all team members associated with a project.
#'
#' @usage
#' codestar_list_team_members(projectId, nextToken, maxResults)
#'
#' @param projectId &#91;required&#93; The ID of the project for which you want to list team members.
#' @param nextToken The continuation token for the next set of results, if the results
#' cannot be returned in one response.
#' @param maxResults The maximum number of team members you want returned in a response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   teamMembers = list(
#'     list(
#'       userArn = "string",
#'       projectRole = "string",
#'       remoteAccessAllowed = TRUE|FALSE
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_team_members(
#'   projectId = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_list_team_members
codestar_list_team_members <- function(projectId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTeamMembers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$list_team_members_input(projectId = projectId, nextToken = nextToken, maxResults = maxResults)
  output <- .codestar$list_team_members_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$list_team_members <- codestar_list_team_members

#' Lists all the user profiles configured for your AWS account in AWS
#' CodeStar
#'
#' @description
#' Lists all the user profiles configured for your AWS account in AWS
#' CodeStar.
#'
#' @usage
#' codestar_list_user_profiles(nextToken, maxResults)
#'
#' @param nextToken The continuation token for the next set of results, if the results
#' cannot be returned in one response.
#' @param maxResults The maximum number of results to return in a response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userProfiles = list(
#'     list(
#'       userArn = "string",
#'       displayName = "string",
#'       emailAddress = "string",
#'       sshPublicKey = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_user_profiles(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_list_user_profiles
codestar_list_user_profiles <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListUserProfiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$list_user_profiles_input(nextToken = nextToken, maxResults = maxResults)
  output <- .codestar$list_user_profiles_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$list_user_profiles <- codestar_list_user_profiles

#' Adds tags to a project
#'
#' @description
#' Adds tags to a project.
#'
#' @usage
#' codestar_tag_project(id, tags)
#'
#' @param id &#91;required&#93; The ID of the project you want to add a tag to.
#' @param tags &#91;required&#93; The tags you want to add to the project.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$tag_project(
#'   id = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_tag_project
codestar_tag_project <- function(id, tags) {
  op <- new_operation(
    name = "TagProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$tag_project_input(id = id, tags = tags)
  output <- .codestar$tag_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$tag_project <- codestar_tag_project

#' Removes tags from a project
#'
#' @description
#' Removes tags from a project.
#'
#' @usage
#' codestar_untag_project(id, tags)
#'
#' @param id &#91;required&#93; The ID of the project to remove tags from.
#' @param tags &#91;required&#93; The tags to remove from the project.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_project(
#'   id = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_untag_project
codestar_untag_project <- function(id, tags) {
  op <- new_operation(
    name = "UntagProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$untag_project_input(id = id, tags = tags)
  output <- .codestar$untag_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$untag_project <- codestar_untag_project

#' Updates a project in AWS CodeStar
#'
#' @description
#' Updates a project in AWS CodeStar.
#'
#' @usage
#' codestar_update_project(id, name, description)
#'
#' @param id &#91;required&#93; The ID of the project you want to update.
#' @param name The name of the project you want to update.
#' @param description The description of the project, if any.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_project(
#'   id = "string",
#'   name = "string",
#'   description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_update_project
codestar_update_project <- function(id, name = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$update_project_input(id = id, name = name, description = description)
  output <- .codestar$update_project_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$update_project <- codestar_update_project

#' Updates a team member's attributes in an AWS CodeStar project
#'
#' @description
#' Updates a team member's attributes in an AWS CodeStar project. For
#' example, you can change a team member's role in the project, or change
#' whether they have remote access to project resources.
#'
#' @usage
#' codestar_update_team_member(projectId, userArn, projectRole,
#'   remoteAccessAllowed)
#'
#' @param projectId &#91;required&#93; The ID of the project.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the user for whom you want to change
#' team membership attributes.
#' @param projectRole The role assigned to the user in the project. Project roles have
#' different levels of access. For more information, see [Working with
#' Teams](https://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
#' in the *AWS CodeStar User Guide*.
#' @param remoteAccessAllowed Whether a team member is allowed to remotely access project resources
#' using the SSH public key associated with the user's profile. Even if
#' this is set to True, the user must associate a public key with their
#' profile before the user can access resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userArn = "string",
#'   projectRole = "string",
#'   remoteAccessAllowed = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_team_member(
#'   projectId = "string",
#'   userArn = "string",
#'   projectRole = "string",
#'   remoteAccessAllowed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_update_team_member
codestar_update_team_member <- function(projectId, userArn, projectRole = NULL, remoteAccessAllowed = NULL) {
  op <- new_operation(
    name = "UpdateTeamMember",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$update_team_member_input(projectId = projectId, userArn = userArn, projectRole = projectRole, remoteAccessAllowed = remoteAccessAllowed)
  output <- .codestar$update_team_member_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$update_team_member <- codestar_update_team_member

#' Updates a user's profile in AWS CodeStar
#'
#' @description
#' Updates a user's profile in AWS CodeStar. The user profile is not
#' project-specific. Information in the user profile is displayed wherever
#' the user's information appears to other users in AWS CodeStar.
#'
#' @usage
#' codestar_update_user_profile(userArn, displayName, emailAddress,
#'   sshPublicKey)
#'
#' @param userArn &#91;required&#93; The name that will be displayed as the friendly name for the user in AWS
#' CodeStar.
#' @param displayName The name that is displayed as the friendly name for the user in AWS
#' CodeStar.
#' @param emailAddress The email address that is displayed as part of the user's profile in AWS
#' CodeStar.
#' @param sshPublicKey The SSH public key associated with the user in AWS CodeStar. If a
#' project owner allows the user remote access to project resources, this
#' public key will be used along with the user's private key for SSH
#' access.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   userArn = "string",
#'   displayName = "string",
#'   emailAddress = "string",
#'   sshPublicKey = "string",
#'   createdTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   lastModifiedTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_user_profile(
#'   userArn = "string",
#'   displayName = "string",
#'   emailAddress = "string",
#'   sshPublicKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codestar_update_user_profile
codestar_update_user_profile <- function(userArn, displayName = NULL, emailAddress = NULL, sshPublicKey = NULL) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestar$update_user_profile_input(userArn = userArn, displayName = displayName, emailAddress = emailAddress, sshPublicKey = sshPublicKey)
  output <- .codestar$update_user_profile_output()
  config <- get_config()
  svc <- .codestar$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestar$operations$update_user_profile <- codestar_update_user_profile
