# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codebuild_service.R
NULL

#' Deletes one or more builds
#'
#' @description
#' Deletes one or more builds.
#'
#' @usage
#' codebuild_batch_delete_builds(ids)
#'
#' @param ids &#91;required&#93; The IDs of the builds to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   buildsDeleted = list(
#'     "string"
#'   ),
#'   buildsNotDeleted = list(
#'     list(
#'       id = "string",
#'       statusCode = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_builds(
#'   ids = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_delete_builds
codebuild_batch_delete_builds <- function(ids) {
  op <- new_operation(
    name = "BatchDeleteBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_delete_builds_input(ids = ids)
  output <- .codebuild$batch_delete_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_delete_builds <- codebuild_batch_delete_builds

#' Retrieves information about one or more batch builds
#'
#' @description
#' Retrieves information about one or more batch builds.
#'
#' @usage
#' codebuild_batch_get_build_batches(ids)
#'
#' @param ids &#91;required&#93; An array that contains the batch build identifiers to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   buildBatches = list(
#'     list(
#'       id = "string",
#'       arn = "string",
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       currentPhase = "string",
#'       buildBatchStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'       sourceVersion = "string",
#'       resolvedSourceVersion = "string",
#'       projectName = "string",
#'       phases = list(
#'         list(
#'           phaseType = "SUBMITTED"|"DOWNLOAD_BATCHSPEC"|"IN_PROGRESS"|"COMBINE_ARTIFACTS"|"SUCCEEDED"|"FAILED"|"STOPPED",
#'           phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           durationInSeconds = 123,
#'           contexts = list(
#'             list(
#'               statusCode = "string",
#'               message = "string"
#'             )
#'           )
#'         )
#'       ),
#'       source = list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       ),
#'       secondarySources = list(
#'         list(
#'           type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'           location = "string",
#'           gitCloneDepth = 123,
#'           gitSubmodulesConfig = list(
#'             fetchSubmodules = TRUE|FALSE
#'           ),
#'           buildspec = "string",
#'           auth = list(
#'             type = "OAUTH",
#'             resource = "string"
#'           ),
#'           reportBuildStatus = TRUE|FALSE,
#'           buildStatusConfig = list(
#'             context = "string",
#'             targetUrl = "string"
#'           ),
#'           insecureSsl = TRUE|FALSE,
#'           sourceIdentifier = "string"
#'         )
#'       ),
#'       secondarySourceVersions = list(
#'         list(
#'           sourceIdentifier = "string",
#'           sourceVersion = "string"
#'         )
#'       ),
#'       artifacts = list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       ),
#'       secondaryArtifacts = list(
#'         list(
#'           location = "string",
#'           sha256sum = "string",
#'           md5sum = "string",
#'           overrideArtifactName = TRUE|FALSE,
#'           encryptionDisabled = TRUE|FALSE,
#'           artifactIdentifier = "string"
#'         )
#'       ),
#'       cache = list(
#'         type = "NO_CACHE"|"S3"|"LOCAL",
#'         location = "string",
#'         modes = list(
#'           "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'         )
#'       ),
#'       environment = list(
#'         type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'         image = "string",
#'         computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'         environmentVariables = list(
#'           list(
#'             name = "string",
#'             value = "string",
#'             type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'           )
#'         ),
#'         privilegedMode = TRUE|FALSE,
#'         certificate = "string",
#'         registryCredential = list(
#'           credential = "string",
#'           credentialProvider = "SECRETS_MANAGER"
#'         ),
#'         imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'       ),
#'       serviceRole = "string",
#'       logConfig = list(
#'         cloudWatchLogs = list(
#'           status = "ENABLED"|"DISABLED",
#'           groupName = "string",
#'           streamName = "string"
#'         ),
#'         s3Logs = list(
#'           status = "ENABLED"|"DISABLED",
#'           location = "string",
#'           encryptionDisabled = TRUE|FALSE
#'         )
#'       ),
#'       buildTimeoutInMinutes = 123,
#'       queuedTimeoutInMinutes = 123,
#'       complete = TRUE|FALSE,
#'       initiator = "string",
#'       vpcConfig = list(
#'         vpcId = "string",
#'         subnets = list(
#'           "string"
#'         ),
#'         securityGroupIds = list(
#'           "string"
#'         )
#'       ),
#'       encryptionKey = "string",
#'       buildBatchNumber = 123,
#'       fileSystemLocations = list(
#'         list(
#'           type = "EFS",
#'           location = "string",
#'           mountPoint = "string",
#'           identifier = "string",
#'           mountOptions = "string"
#'         )
#'       ),
#'       buildBatchConfig = list(
#'         serviceRole = "string",
#'         combineArtifacts = TRUE|FALSE,
#'         restrictions = list(
#'           maximumBuildsAllowed = 123,
#'           computeTypesAllowed = list(
#'             "string"
#'           )
#'         ),
#'         timeoutInMins = 123
#'       ),
#'       buildGroups = list(
#'         list(
#'           identifier = "string",
#'           dependsOn = list(
#'             "string"
#'           ),
#'           ignoreFailure = TRUE|FALSE,
#'           currentBuildSummary = list(
#'             arn = "string",
#'             requestedOn = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'             primaryArtifact = list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             ),
#'             secondaryArtifacts = list(
#'               list(
#'                 type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                 location = "string",
#'                 identifier = "string"
#'               )
#'             )
#'           ),
#'           priorBuildSummaryList = list(
#'             list(
#'               arn = "string",
#'               requestedOn = as.POSIXct(
#'                 "2015-01-01"
#'               ),
#'               buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'               primaryArtifact = list(
#'                 type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                 location = "string",
#'                 identifier = "string"
#'               ),
#'               secondaryArtifacts = list(
#'                 list(
#'                   type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                   location = "string",
#'                   identifier = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   buildBatchesNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_build_batches(
#'   ids = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_build_batches
codebuild_batch_get_build_batches <- function(ids) {
  op <- new_operation(
    name = "BatchGetBuildBatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_build_batches_input(ids = ids)
  output <- .codebuild$batch_get_build_batches_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_build_batches <- codebuild_batch_get_build_batches

#' Gets information about one or more builds
#'
#' @description
#' Gets information about one or more builds.
#'
#' @usage
#' codebuild_batch_get_builds(ids)
#'
#' @param ids &#91;required&#93; The IDs of the builds.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   builds = list(
#'     list(
#'       id = "string",
#'       arn = "string",
#'       buildNumber = 123,
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       currentPhase = "string",
#'       buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'       sourceVersion = "string",
#'       resolvedSourceVersion = "string",
#'       projectName = "string",
#'       phases = list(
#'         list(
#'           phaseType = "SUBMITTED"|"QUEUED"|"PROVISIONING"|"DOWNLOAD_SOURCE"|"INSTALL"|"PRE_BUILD"|"BUILD"|"POST_BUILD"|"UPLOAD_ARTIFACTS"|"FINALIZING"|"COMPLETED",
#'           phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           durationInSeconds = 123,
#'           contexts = list(
#'             list(
#'               statusCode = "string",
#'               message = "string"
#'             )
#'           )
#'         )
#'       ),
#'       source = list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       ),
#'       secondarySources = list(
#'         list(
#'           type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'           location = "string",
#'           gitCloneDepth = 123,
#'           gitSubmodulesConfig = list(
#'             fetchSubmodules = TRUE|FALSE
#'           ),
#'           buildspec = "string",
#'           auth = list(
#'             type = "OAUTH",
#'             resource = "string"
#'           ),
#'           reportBuildStatus = TRUE|FALSE,
#'           buildStatusConfig = list(
#'             context = "string",
#'             targetUrl = "string"
#'           ),
#'           insecureSsl = TRUE|FALSE,
#'           sourceIdentifier = "string"
#'         )
#'       ),
#'       secondarySourceVersions = list(
#'         list(
#'           sourceIdentifier = "string",
#'           sourceVersion = "string"
#'         )
#'       ),
#'       artifacts = list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       ),
#'       secondaryArtifacts = list(
#'         list(
#'           location = "string",
#'           sha256sum = "string",
#'           md5sum = "string",
#'           overrideArtifactName = TRUE|FALSE,
#'           encryptionDisabled = TRUE|FALSE,
#'           artifactIdentifier = "string"
#'         )
#'       ),
#'       cache = list(
#'         type = "NO_CACHE"|"S3"|"LOCAL",
#'         location = "string",
#'         modes = list(
#'           "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'         )
#'       ),
#'       environment = list(
#'         type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'         image = "string",
#'         computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'         environmentVariables = list(
#'           list(
#'             name = "string",
#'             value = "string",
#'             type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'           )
#'         ),
#'         privilegedMode = TRUE|FALSE,
#'         certificate = "string",
#'         registryCredential = list(
#'           credential = "string",
#'           credentialProvider = "SECRETS_MANAGER"
#'         ),
#'         imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'       ),
#'       serviceRole = "string",
#'       logs = list(
#'         groupName = "string",
#'         streamName = "string",
#'         deepLink = "string",
#'         s3DeepLink = "string",
#'         cloudWatchLogsArn = "string",
#'         s3LogsArn = "string",
#'         cloudWatchLogs = list(
#'           status = "ENABLED"|"DISABLED",
#'           groupName = "string",
#'           streamName = "string"
#'         ),
#'         s3Logs = list(
#'           status = "ENABLED"|"DISABLED",
#'           location = "string",
#'           encryptionDisabled = TRUE|FALSE
#'         )
#'       ),
#'       timeoutInMinutes = 123,
#'       queuedTimeoutInMinutes = 123,
#'       buildComplete = TRUE|FALSE,
#'       initiator = "string",
#'       vpcConfig = list(
#'         vpcId = "string",
#'         subnets = list(
#'           "string"
#'         ),
#'         securityGroupIds = list(
#'           "string"
#'         )
#'       ),
#'       networkInterface = list(
#'         subnetId = "string",
#'         networkInterfaceId = "string"
#'       ),
#'       encryptionKey = "string",
#'       exportedEnvironmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string"
#'         )
#'       ),
#'       reportArns = list(
#'         "string"
#'       ),
#'       fileSystemLocations = list(
#'         list(
#'           type = "EFS",
#'           location = "string",
#'           mountPoint = "string",
#'           identifier = "string",
#'           mountOptions = "string"
#'         )
#'       ),
#'       debugSession = list(
#'         sessionEnabled = TRUE|FALSE,
#'         sessionTarget = "string"
#'       ),
#'       buildBatchArn = "string"
#'     )
#'   ),
#'   buildsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_builds(
#'   ids = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example gets information about builds with the specified
#' # build IDs.
#' svc$batch_get_builds(
#'   ids = list(
#'     "codebuild-demo-project:9b0ac37f-d19e-4254-9079-f47e9a389eEX",
#'     "codebuild-demo-project:b79a46f7-1473-4636-a23f-da9c45c208EX"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_builds
codebuild_batch_get_builds <- function(ids) {
  op <- new_operation(
    name = "BatchGetBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_builds_input(ids = ids)
  output <- .codebuild$batch_get_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_builds <- codebuild_batch_get_builds

#' Gets information about one or more build projects
#'
#' @description
#' Gets information about one or more build projects.
#'
#' @usage
#' codebuild_batch_get_projects(names)
#'
#' @param names &#91;required&#93; The names or ARNs of the build projects. To get information about a
#' project shared with your AWS account, its ARN must be specified. You
#' cannot specify a shared project using its name.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   projects = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       description = "string",
#'       source = list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       ),
#'       secondarySources = list(
#'         list(
#'           type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'           location = "string",
#'           gitCloneDepth = 123,
#'           gitSubmodulesConfig = list(
#'             fetchSubmodules = TRUE|FALSE
#'           ),
#'           buildspec = "string",
#'           auth = list(
#'             type = "OAUTH",
#'             resource = "string"
#'           ),
#'           reportBuildStatus = TRUE|FALSE,
#'           buildStatusConfig = list(
#'             context = "string",
#'             targetUrl = "string"
#'           ),
#'           insecureSsl = TRUE|FALSE,
#'           sourceIdentifier = "string"
#'         )
#'       ),
#'       sourceVersion = "string",
#'       secondarySourceVersions = list(
#'         list(
#'           sourceIdentifier = "string",
#'           sourceVersion = "string"
#'         )
#'       ),
#'       artifacts = list(
#'         type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'         location = "string",
#'         path = "string",
#'         namespaceType = "NONE"|"BUILD_ID",
#'         name = "string",
#'         packaging = "NONE"|"ZIP",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       ),
#'       secondaryArtifacts = list(
#'         list(
#'           type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'           location = "string",
#'           path = "string",
#'           namespaceType = "NONE"|"BUILD_ID",
#'           name = "string",
#'           packaging = "NONE"|"ZIP",
#'           overrideArtifactName = TRUE|FALSE,
#'           encryptionDisabled = TRUE|FALSE,
#'           artifactIdentifier = "string"
#'         )
#'       ),
#'       cache = list(
#'         type = "NO_CACHE"|"S3"|"LOCAL",
#'         location = "string",
#'         modes = list(
#'           "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'         )
#'       ),
#'       environment = list(
#'         type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'         image = "string",
#'         computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'         environmentVariables = list(
#'           list(
#'             name = "string",
#'             value = "string",
#'             type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'           )
#'         ),
#'         privilegedMode = TRUE|FALSE,
#'         certificate = "string",
#'         registryCredential = list(
#'           credential = "string",
#'           credentialProvider = "SECRETS_MANAGER"
#'         ),
#'         imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'       ),
#'       serviceRole = "string",
#'       timeoutInMinutes = 123,
#'       queuedTimeoutInMinutes = 123,
#'       encryptionKey = "string",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastModified = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       webhook = list(
#'         url = "string",
#'         payloadUrl = "string",
#'         secret = "string",
#'         branchFilter = "string",
#'         filterGroups = list(
#'           list(
#'             list(
#'               type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'               pattern = "string",
#'               excludeMatchedPattern = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         buildType = "BUILD"|"BUILD_BATCH",
#'         lastModifiedSecret = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       vpcConfig = list(
#'         vpcId = "string",
#'         subnets = list(
#'           "string"
#'         ),
#'         securityGroupIds = list(
#'           "string"
#'         )
#'       ),
#'       badge = list(
#'         badgeEnabled = TRUE|FALSE,
#'         badgeRequestUrl = "string"
#'       ),
#'       logsConfig = list(
#'         cloudWatchLogs = list(
#'           status = "ENABLED"|"DISABLED",
#'           groupName = "string",
#'           streamName = "string"
#'         ),
#'         s3Logs = list(
#'           status = "ENABLED"|"DISABLED",
#'           location = "string",
#'           encryptionDisabled = TRUE|FALSE
#'         )
#'       ),
#'       fileSystemLocations = list(
#'         list(
#'           type = "EFS",
#'           location = "string",
#'           mountPoint = "string",
#'           identifier = "string",
#'           mountOptions = "string"
#'         )
#'       ),
#'       buildBatchConfig = list(
#'         serviceRole = "string",
#'         combineArtifacts = TRUE|FALSE,
#'         restrictions = list(
#'           maximumBuildsAllowed = 123,
#'           computeTypesAllowed = list(
#'             "string"
#'           )
#'         ),
#'         timeoutInMins = 123
#'       )
#'     )
#'   ),
#'   projectsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_projects(
#'   names = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_projects
codebuild_batch_get_projects <- function(names) {
  op <- new_operation(
    name = "BatchGetProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_projects_input(names = names)
  output <- .codebuild$batch_get_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_projects <- codebuild_batch_get_projects

#' Returns an array of report groups
#'
#' @description
#' Returns an array of report groups.
#'
#' @usage
#' codebuild_batch_get_report_groups(reportGroupArns)
#'
#' @param reportGroupArns &#91;required&#93; An array of report group ARNs that identify the report groups to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   reportGroups = list(
#'     list(
#'       arn = "string",
#'       name = "string",
#'       type = "TEST"|"CODE_COVERAGE",
#'       exportConfig = list(
#'         exportConfigType = "S3"|"NO_EXPORT",
#'         s3Destination = list(
#'           bucket = "string",
#'           path = "string",
#'           packaging = "ZIP"|"NONE",
#'           encryptionKey = "string",
#'           encryptionDisabled = TRUE|FALSE
#'         )
#'       ),
#'       created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastModified = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       status = "ACTIVE"|"DELETING"
#'     )
#'   ),
#'   reportGroupsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_report_groups(
#'   reportGroupArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_report_groups
codebuild_batch_get_report_groups <- function(reportGroupArns) {
  op <- new_operation(
    name = "BatchGetReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_report_groups_input(reportGroupArns = reportGroupArns)
  output <- .codebuild$batch_get_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_report_groups <- codebuild_batch_get_report_groups

#' Returns an array of reports
#'
#' @description
#' Returns an array of reports.
#'
#' @usage
#' codebuild_batch_get_reports(reportArns)
#'
#' @param reportArns &#91;required&#93; An array of ARNs that identify the `Report` objects to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   reports = list(
#'     list(
#'       arn = "string",
#'       type = "TEST"|"CODE_COVERAGE",
#'       name = "string",
#'       reportGroupArn = "string",
#'       executionId = "string",
#'       status = "GENERATING"|"SUCCEEDED"|"FAILED"|"INCOMPLETE"|"DELETING",
#'       created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       expired = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       exportConfig = list(
#'         exportConfigType = "S3"|"NO_EXPORT",
#'         s3Destination = list(
#'           bucket = "string",
#'           path = "string",
#'           packaging = "ZIP"|"NONE",
#'           encryptionKey = "string",
#'           encryptionDisabled = TRUE|FALSE
#'         )
#'       ),
#'       truncated = TRUE|FALSE,
#'       testSummary = list(
#'         total = 123,
#'         statusCounts = list(
#'           123
#'         ),
#'         durationInNanoSeconds = 123
#'       ),
#'       codeCoverageSummary = list(
#'         lineCoveragePercentage = 123.0,
#'         linesCovered = 123,
#'         linesMissed = 123,
#'         branchCoveragePercentage = 123.0,
#'         branchesCovered = 123,
#'         branchesMissed = 123
#'       )
#'     )
#'   ),
#'   reportsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_reports(
#'   reportArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_reports
codebuild_batch_get_reports <- function(reportArns) {
  op <- new_operation(
    name = "BatchGetReports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_reports_input(reportArns = reportArns)
  output <- .codebuild$batch_get_reports_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_reports <- codebuild_batch_get_reports

#' Creates a build project
#'
#' @description
#' Creates a build project.
#'
#' @usage
#' codebuild_create_project(name, description, source, secondarySources,
#'   sourceVersion, secondarySourceVersions, artifacts, secondaryArtifacts,
#'   cache, environment, serviceRole, timeoutInMinutes,
#'   queuedTimeoutInMinutes, encryptionKey, tags, vpcConfig, badgeEnabled,
#'   logsConfig, fileSystemLocations, buildBatchConfig)
#'
#' @param name &#91;required&#93; The name of the build project.
#' @param description A description that makes the build project easy to identify.
#' @param source &#91;required&#93; Information about the build input source code for the build project.
#' @param secondarySources An array of `ProjectSource` objects.
#' @param sourceVersion A version of the build input to be built for this project. If not
#' specified, the latest version is used. If specified, it must be one of:
#' 
#' -   For AWS CodeCommit: the commit ID, branch, or Git tag to use.
#' 
#' -   For GitHub: the commit ID, pull request ID, branch name, or tag name
#'     that corresponds to the version of the source code you want to
#'     build. If a pull request ID is specified, it must use the format
#'     `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#'     specified, the branch's HEAD commit ID is used. If not specified,
#'     the default branch's HEAD commit ID is used.
#' 
#' -   For Bitbucket: the commit ID, branch name, or tag name that
#'     corresponds to the version of the source code you want to build. If
#'     a branch name is specified, the branch's HEAD commit ID is used. If
#'     not specified, the default branch's HEAD commit ID is used.
#' 
#' -   For Amazon Simple Storage Service (Amazon S3): the version ID of the
#'     object that represents the build input ZIP file to use.
#' 
#' If `sourceVersion` is specified at the build level, then that version
#' takes precedence over this `sourceVersion` (at the project level).
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *AWS CodeBuild User Guide*.
#' @param secondarySourceVersions An array of `ProjectSourceVersion` objects. If `secondarySourceVersions`
#' is specified at the build level, then they take precedence over these
#' `secondarySourceVersions` (at the project level).
#' @param artifacts &#91;required&#93; Information about the build output artifacts for the build project.
#' @param secondaryArtifacts An array of `ProjectArtifacts` objects.
#' @param cache Stores recently used information so that it can be quickly accessed at a
#' later time.
#' @param environment &#91;required&#93; Information about the build environment for the build project.
#' @param serviceRole &#91;required&#93; The ARN of the AWS Identity and Access Management (IAM) role that
#' enables AWS CodeBuild to interact with dependent AWS services on behalf
#' of the AWS account.
#' @param timeoutInMinutes How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
#' before it times out any build that has not been marked as completed. The
#' default is 60 minutes.
#' @param queuedTimeoutInMinutes The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKey The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
#' used for encrypting the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param tags A list of tag key and value pairs associated with this build project.
#' 
#' These tags are available for use by AWS services that support AWS
#' CodeBuild build project tags.
#' @param vpcConfig VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
#' @param badgeEnabled Set this to true to generate a publicly accessible URL for your
#' project's build badge.
#' @param logsConfig Information about logs for the build project. These can be logs in
#' Amazon CloudWatch Logs, logs uploaded to a specified S3 bucket, or both.
#' @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build
#' project. A `ProjectFileSystemLocation` object specifies the
#' `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a
#' file system created using Amazon Elastic File System.
#' @param buildBatchConfig A ProjectBuildBatchConfig object that defines the batch build options
#' for the project.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   project = list(
#'     name = "string",
#'     arn = "string",
#'     description = "string",
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     sourceVersion = "string",
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'         location = "string",
#'         path = "string",
#'         namespaceType = "NONE"|"BUILD_ID",
#'         name = "string",
#'         packaging = "NONE"|"ZIP",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     timeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     encryptionKey = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastModified = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     webhook = list(
#'       url = "string",
#'       payloadUrl = "string",
#'       secret = "string",
#'       branchFilter = "string",
#'       filterGroups = list(
#'         list(
#'           list(
#'             type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'             pattern = "string",
#'             excludeMatchedPattern = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       buildType = "BUILD"|"BUILD_BATCH",
#'       lastModifiedSecret = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     badge = list(
#'       badgeEnabled = TRUE|FALSE,
#'       badgeRequestUrl = "string"
#'     ),
#'     logsConfig = list(
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     buildBatchConfig = list(
#'       serviceRole = "string",
#'       combineArtifacts = TRUE|FALSE,
#'       restrictions = list(
#'         maximumBuildsAllowed = 123,
#'         computeTypesAllowed = list(
#'           "string"
#'         )
#'       ),
#'       timeoutInMins = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_project(
#'   name = "string",
#'   description = "string",
#'   source = list(
#'     type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'     location = "string",
#'     gitCloneDepth = 123,
#'     gitSubmodulesConfig = list(
#'       fetchSubmodules = TRUE|FALSE
#'     ),
#'     buildspec = "string",
#'     auth = list(
#'       type = "OAUTH",
#'       resource = "string"
#'     ),
#'     reportBuildStatus = TRUE|FALSE,
#'     buildStatusConfig = list(
#'       context = "string",
#'       targetUrl = "string"
#'     ),
#'     insecureSsl = TRUE|FALSE,
#'     sourceIdentifier = "string"
#'   ),
#'   secondarySources = list(
#'     list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     )
#'   ),
#'   sourceVersion = "string",
#'   secondarySourceVersions = list(
#'     list(
#'       sourceIdentifier = "string",
#'       sourceVersion = "string"
#'     )
#'   ),
#'   artifacts = list(
#'     type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'     location = "string",
#'     path = "string",
#'     namespaceType = "NONE"|"BUILD_ID",
#'     name = "string",
#'     packaging = "NONE"|"ZIP",
#'     overrideArtifactName = TRUE|FALSE,
#'     encryptionDisabled = TRUE|FALSE,
#'     artifactIdentifier = "string"
#'   ),
#'   secondaryArtifacts = list(
#'     list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     )
#'   ),
#'   cache = list(
#'     type = "NO_CACHE"|"S3"|"LOCAL",
#'     location = "string",
#'     modes = list(
#'       "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'     )
#'   ),
#'   environment = list(
#'     type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'     image = "string",
#'     computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'     environmentVariables = list(
#'       list(
#'         name = "string",
#'         value = "string",
#'         type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'       )
#'     ),
#'     privilegedMode = TRUE|FALSE,
#'     certificate = "string",
#'     registryCredential = list(
#'       credential = "string",
#'       credentialProvider = "SECRETS_MANAGER"
#'     ),
#'     imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'   ),
#'   serviceRole = "string",
#'   timeoutInMinutes = 123,
#'   queuedTimeoutInMinutes = 123,
#'   encryptionKey = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   vpcConfig = list(
#'     vpcId = "string",
#'     subnets = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   badgeEnabled = TRUE|FALSE,
#'   logsConfig = list(
#'     cloudWatchLogs = list(
#'       status = "ENABLED"|"DISABLED",
#'       groupName = "string",
#'       streamName = "string"
#'     ),
#'     s3Logs = list(
#'       status = "ENABLED"|"DISABLED",
#'       location = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   fileSystemLocations = list(
#'     list(
#'       type = "EFS",
#'       location = "string",
#'       mountPoint = "string",
#'       identifier = "string",
#'       mountOptions = "string"
#'     )
#'   ),
#'   buildBatchConfig = list(
#'     serviceRole = "string",
#'     combineArtifacts = TRUE|FALSE,
#'     restrictions = list(
#'       maximumBuildsAllowed = 123,
#'       computeTypesAllowed = list(
#'         "string"
#'       )
#'     ),
#'     timeoutInMins = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_create_project
codebuild_create_project <- function(name, description = NULL, source, secondarySources = NULL, sourceVersion = NULL, secondarySourceVersions = NULL, artifacts, secondaryArtifacts = NULL, cache = NULL, environment, serviceRole, timeoutInMinutes = NULL, queuedTimeoutInMinutes = NULL, encryptionKey = NULL, tags = NULL, vpcConfig = NULL, badgeEnabled = NULL, logsConfig = NULL, fileSystemLocations = NULL, buildBatchConfig = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_project_input(name = name, description = description, source = source, secondarySources = secondarySources, sourceVersion = sourceVersion, secondarySourceVersions = secondarySourceVersions, artifacts = artifacts, secondaryArtifacts = secondaryArtifacts, cache = cache, environment = environment, serviceRole = serviceRole, timeoutInMinutes = timeoutInMinutes, queuedTimeoutInMinutes = queuedTimeoutInMinutes, encryptionKey = encryptionKey, tags = tags, vpcConfig = vpcConfig, badgeEnabled = badgeEnabled, logsConfig = logsConfig, fileSystemLocations = fileSystemLocations, buildBatchConfig = buildBatchConfig)
  output <- .codebuild$create_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_project <- codebuild_create_project

#' Creates a report group
#'
#' @description
#' Creates a report group. A report group contains a collection of reports.
#'
#' @usage
#' codebuild_create_report_group(name, type, exportConfig, tags)
#'
#' @param name &#91;required&#93; The name of the report group.
#' @param type &#91;required&#93; The type of report group.
#' @param exportConfig &#91;required&#93; A `ReportExportConfig` object that contains information about where the
#' report group test results are exported.
#' @param tags A list of tag key and value pairs associated with this report group.
#' 
#' These tags are available for use by AWS services that support AWS
#' CodeBuild report group tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   reportGroup = list(
#'     arn = "string",
#'     name = "string",
#'     type = "TEST"|"CODE_COVERAGE",
#'     exportConfig = list(
#'       exportConfigType = "S3"|"NO_EXPORT",
#'       s3Destination = list(
#'         bucket = "string",
#'         path = "string",
#'         packaging = "ZIP"|"NONE",
#'         encryptionKey = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastModified = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     status = "ACTIVE"|"DELETING"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_report_group(
#'   name = "string",
#'   type = "TEST"|"CODE_COVERAGE",
#'   exportConfig = list(
#'     exportConfigType = "S3"|"NO_EXPORT",
#'     s3Destination = list(
#'       bucket = "string",
#'       path = "string",
#'       packaging = "ZIP"|"NONE",
#'       encryptionKey = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_create_report_group
codebuild_create_report_group <- function(name, type, exportConfig, tags = NULL) {
  op <- new_operation(
    name = "CreateReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_report_group_input(name = name, type = type, exportConfig = exportConfig, tags = tags)
  output <- .codebuild$create_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_report_group <- codebuild_create_report_group

#' For an existing AWS CodeBuild build project that has its source code
#' stored in a GitHub or Bitbucket repository, enables AWS CodeBuild to
#' start rebuilding the source code every time a code change is pushed to
#' the repository
#'
#' @description
#' For an existing AWS CodeBuild build project that has its source code
#' stored in a GitHub or Bitbucket repository, enables AWS CodeBuild to
#' start rebuilding the source code every time a code change is pushed to
#' the repository.
#' 
#' If you enable webhooks for an AWS CodeBuild project, and the project is
#' used as a build step in AWS CodePipeline, then two identical builds are
#' created for each commit. One build is triggered through webhooks, and
#' one through AWS CodePipeline. Because billing is on a per-build basis,
#' you are billed for both builds. Therefore, if you are using AWS
#' CodePipeline, we recommend that you disable webhooks in AWS CodeBuild.
#' In the AWS CodeBuild console, clear the Webhook box. For more
#' information, see step 5 in [Change a Build Project's
#' Settings](https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console).
#'
#' @usage
#' codebuild_create_webhook(projectName, branchFilter, filterGroups,
#'   buildType)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild project.
#' @param branchFilter A regular expression used to determine which repository branches are
#' built when a webhook is triggered. If the name of a branch matches the
#' regular expression, then it is built. If `branchFilter` is empty, then
#' all branches are built.
#' 
#' It is recommended that you use `filterGroups` instead of `branchFilter`.
#' @param filterGroups An array of arrays of `WebhookFilter` objects used to determine which
#' webhooks are triggered. At least one `WebhookFilter` in the array must
#' specify `EVENT` as its `type`.
#' 
#' For a build to be triggered, at least one filter group in the
#' `filterGroups` array must pass. For a filter group to pass, each of its
#' filters must pass.
#' @param buildType Specifies the type of build this webhook will trigger.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   webhook = list(
#'     url = "string",
#'     payloadUrl = "string",
#'     secret = "string",
#'     branchFilter = "string",
#'     filterGroups = list(
#'       list(
#'         list(
#'           type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'           pattern = "string",
#'           excludeMatchedPattern = TRUE|FALSE
#'         )
#'       )
#'     ),
#'     buildType = "BUILD"|"BUILD_BATCH",
#'     lastModifiedSecret = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_webhook(
#'   projectName = "string",
#'   branchFilter = "string",
#'   filterGroups = list(
#'     list(
#'       list(
#'         type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'         pattern = "string",
#'         excludeMatchedPattern = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   buildType = "BUILD"|"BUILD_BATCH"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_create_webhook
codebuild_create_webhook <- function(projectName, branchFilter = NULL, filterGroups = NULL, buildType = NULL) {
  op <- new_operation(
    name = "CreateWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_webhook_input(projectName = projectName, branchFilter = branchFilter, filterGroups = filterGroups, buildType = buildType)
  output <- .codebuild$create_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_webhook <- codebuild_create_webhook

#' Deletes a batch build
#'
#' @description
#' Deletes a batch build.
#'
#' @usage
#' codebuild_delete_build_batch(id)
#'
#' @param id &#91;required&#93; The identifier of the batch build to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   statusCode = "string",
#'   buildsDeleted = list(
#'     "string"
#'   ),
#'   buildsNotDeleted = list(
#'     list(
#'       id = "string",
#'       statusCode = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_build_batch(
#'   id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_build_batch
codebuild_delete_build_batch <- function(id) {
  op <- new_operation(
    name = "DeleteBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_build_batch_input(id = id)
  output <- .codebuild$delete_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_build_batch <- codebuild_delete_build_batch

#' Deletes a build project
#'
#' @description
#' Deletes a build project. When you delete a project, its builds are not
#' deleted.
#'
#' @usage
#' codebuild_delete_project(name)
#'
#' @param name &#91;required&#93; The name of the build project.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_project(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_project
codebuild_delete_project <- function(name) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_project_input(name = name)
  output <- .codebuild$delete_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_project <- codebuild_delete_project

#' Deletes a report
#'
#' @description
#' Deletes a report.
#'
#' @usage
#' codebuild_delete_report(arn)
#'
#' @param arn &#91;required&#93; The ARN of the report to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_report(
#'   arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_report
codebuild_delete_report <- function(arn) {
  op <- new_operation(
    name = "DeleteReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_report_input(arn = arn)
  output <- .codebuild$delete_report_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_report <- codebuild_delete_report

#' Deletes a report group
#'
#' @description
#' Deletes a report group. Before you delete a report group, you must
#' delete its reports.
#'
#' @usage
#' codebuild_delete_report_group(arn, deleteReports)
#'
#' @param arn &#91;required&#93; The ARN of the report group to delete.
#' @param deleteReports If `true`, deletes any reports that belong to a report group before
#' deleting the report group.
#' 
#' If `false`, you must delete any reports in the report group. Use
#' [`list_reports_for_report_group`][codebuild_list_reports_for_report_group]
#' to get the reports in a report group. Use
#' [`delete_report`][codebuild_delete_report] to delete the reports. If you
#' call [`delete_report_group`][codebuild_delete_report_group] for a report
#' group that contains one or more reports, an exception is thrown.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_report_group(
#'   arn = "string",
#'   deleteReports = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_report_group
codebuild_delete_report_group <- function(arn, deleteReports = NULL) {
  op <- new_operation(
    name = "DeleteReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_report_group_input(arn = arn, deleteReports = deleteReports)
  output <- .codebuild$delete_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_report_group <- codebuild_delete_report_group

#' Deletes a resource policy that is identified by its resource ARN
#'
#' @description
#' Deletes a resource policy that is identified by its resource ARN.
#'
#' @usage
#' codebuild_delete_resource_policy(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that is associated with the resource policy.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_policy(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_resource_policy
codebuild_delete_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_resource_policy_input(resourceArn = resourceArn)
  output <- .codebuild$delete_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_resource_policy <- codebuild_delete_resource_policy

#' Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source
#' credentials
#'
#' @description
#' Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source
#' credentials.
#'
#' @usage
#' codebuild_delete_source_credentials(arn)
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   arn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_source_credentials(
#'   arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_source_credentials
codebuild_delete_source_credentials <- function(arn) {
  op <- new_operation(
    name = "DeleteSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_source_credentials_input(arn = arn)
  output <- .codebuild$delete_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_source_credentials <- codebuild_delete_source_credentials

#' For an existing AWS CodeBuild build project that has its source code
#' stored in a GitHub or Bitbucket repository, stops AWS CodeBuild from
#' rebuilding the source code every time a code change is pushed to the
#' repository
#'
#' @description
#' For an existing AWS CodeBuild build project that has its source code
#' stored in a GitHub or Bitbucket repository, stops AWS CodeBuild from
#' rebuilding the source code every time a code change is pushed to the
#' repository.
#'
#' @usage
#' codebuild_delete_webhook(projectName)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild project.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_webhook(
#'   projectName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_webhook
codebuild_delete_webhook <- function(projectName) {
  op <- new_operation(
    name = "DeleteWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_webhook_input(projectName = projectName)
  output <- .codebuild$delete_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_webhook <- codebuild_delete_webhook

#' Retrieves one or more code coverage reports
#'
#' @description
#' Retrieves one or more code coverage reports.
#'
#' @usage
#' codebuild_describe_code_coverages(reportArn, nextToken, maxResults,
#'   sortOrder, sortBy, minLineCoveragePercentage, maxLineCoveragePercentage)
#'
#' @param reportArn &#91;required&#93; The ARN of the report for which test cases are returned.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`describe_code_coverages`][codebuild_describe_code_coverages]. This
#' specifies the next item to return. To return the beginning of the list,
#' exclude this parameter.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies if the results are sorted in ascending or descending order.
#' @param sortBy Specifies how the results are sorted. Possible values are:
#' 
#' ### FILE_PATH
#' 
#' The results are sorted by file path.
#' 
#' ### LINE_COVERAGE_PERCENTAGE
#' 
#' The results are sorted by the percentage of lines that are covered.
#' @param minLineCoveragePercentage The minimum line coverage percentage to report.
#' @param maxLineCoveragePercentage The maximum line coverage percentage to report.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   codeCoverages = list(
#'     list(
#'       id = "string",
#'       reportARN = "string",
#'       filePath = "string",
#'       lineCoveragePercentage = 123.0,
#'       linesCovered = 123,
#'       linesMissed = 123,
#'       branchCoveragePercentage = 123.0,
#'       branchesCovered = 123,
#'       branchesMissed = 123,
#'       expired = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_code_coverages(
#'   reportArn = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   sortBy = "LINE_COVERAGE_PERCENTAGE"|"FILE_PATH",
#'   minLineCoveragePercentage = 123.0,
#'   maxLineCoveragePercentage = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_describe_code_coverages
codebuild_describe_code_coverages <- function(reportArn, nextToken = NULL, maxResults = NULL, sortOrder = NULL, sortBy = NULL, minLineCoveragePercentage = NULL, maxLineCoveragePercentage = NULL) {
  op <- new_operation(
    name = "DescribeCodeCoverages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$describe_code_coverages_input(reportArn = reportArn, nextToken = nextToken, maxResults = maxResults, sortOrder = sortOrder, sortBy = sortBy, minLineCoveragePercentage = minLineCoveragePercentage, maxLineCoveragePercentage = maxLineCoveragePercentage)
  output <- .codebuild$describe_code_coverages_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$describe_code_coverages <- codebuild_describe_code_coverages

#' Returns a list of details about test cases for a report
#'
#' @description
#' Returns a list of details about test cases for a report.
#'
#' @usage
#' codebuild_describe_test_cases(reportArn, nextToken, maxResults, filter)
#'
#' @param reportArn &#91;required&#93; The ARN of the report for which test cases are returned.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated test cases returned per response. Use
#' `nextToken` to iterate pages in the list of returned `TestCase` objects.
#' The default value is 100.
#' @param filter A `TestCaseFilter` object used to filter the returned reports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   testCases = list(
#'     list(
#'       reportArn = "string",
#'       testRawDataPath = "string",
#'       prefix = "string",
#'       name = "string",
#'       status = "string",
#'       durationInNanoSeconds = 123,
#'       message = "string",
#'       expired = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_test_cases(
#'   reportArn = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   filter = list(
#'     status = "string",
#'     keyword = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_describe_test_cases
codebuild_describe_test_cases <- function(reportArn, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "DescribeTestCases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$describe_test_cases_input(reportArn = reportArn, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .codebuild$describe_test_cases_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$describe_test_cases <- codebuild_describe_test_cases

#' Get report group trend
#'
#' @description
#' Get report group trend
#'
#' @usage
#' codebuild_get_report_group_trend(reportGroupArn, numOfReports,
#'   trendField)
#'
#' @param reportGroupArn &#91;required&#93; 
#' @param numOfReports 
#' @param trendField &#91;required&#93; 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   stats = list(
#'     average = "string",
#'     max = "string",
#'     min = "string"
#'   ),
#'   rawData = list(
#'     list(
#'       reportArn = "string",
#'       data = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_report_group_trend(
#'   reportGroupArn = "string",
#'   numOfReports = 123,
#'   trendField = "PASS_RATE"|"DURATION"|"TOTAL"|"LINE_COVERAGE"|"LINES_COVERED"|"LINES_MISSED"|"BRANCH_COVERAGE"|"BRANCHES_COVERED"|"BRANCHES_MISSED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_get_report_group_trend
codebuild_get_report_group_trend <- function(reportGroupArn, numOfReports = NULL, trendField) {
  op <- new_operation(
    name = "GetReportGroupTrend",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$get_report_group_trend_input(reportGroupArn = reportGroupArn, numOfReports = numOfReports, trendField = trendField)
  output <- .codebuild$get_report_group_trend_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$get_report_group_trend <- codebuild_get_report_group_trend

#' Gets a resource policy that is identified by its resource ARN
#'
#' @description
#' Gets a resource policy that is identified by its resource ARN.
#'
#' @usage
#' codebuild_get_resource_policy(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that is associated with the resource policy.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   policy = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policy(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_get_resource_policy
codebuild_get_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$get_resource_policy_input(resourceArn = resourceArn)
  output <- .codebuild$get_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$get_resource_policy <- codebuild_get_resource_policy

#' Imports the source repository credentials for an AWS CodeBuild project
#' that has its source code stored in a GitHub, GitHub Enterprise, or
#' Bitbucket repository
#'
#' @description
#' Imports the source repository credentials for an AWS CodeBuild project
#' that has its source code stored in a GitHub, GitHub Enterprise, or
#' Bitbucket repository.
#'
#' @usage
#' codebuild_import_source_credentials(username, token, serverType,
#'   authType, shouldOverwrite)
#'
#' @param username The Bitbucket username when the `authType` is BASIC_AUTH. This
#' parameter is not valid for other types of source providers or
#' connections.
#' @param token &#91;required&#93; For GitHub or GitHub Enterprise, this is the personal access token. For
#' Bitbucket, this is the app password.
#' @param serverType &#91;required&#93; The source provider used for this project.
#' @param authType &#91;required&#93; The type of authentication used to connect to a GitHub, GitHub
#' Enterprise, or Bitbucket repository. An OAUTH connection is not
#' supported by the API and must be created using the AWS CodeBuild
#' console.
#' @param shouldOverwrite Set to `false` to prevent overwriting the repository source credentials.
#' Set to `true` to overwrite the repository source credentials. The
#' default value is `true`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   arn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$import_source_credentials(
#'   username = "string",
#'   token = "string",
#'   serverType = "GITHUB"|"BITBUCKET"|"GITHUB_ENTERPRISE",
#'   authType = "OAUTH"|"BASIC_AUTH"|"PERSONAL_ACCESS_TOKEN",
#'   shouldOverwrite = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_import_source_credentials
codebuild_import_source_credentials <- function(username = NULL, token, serverType, authType, shouldOverwrite = NULL) {
  op <- new_operation(
    name = "ImportSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$import_source_credentials_input(username = username, token = token, serverType = serverType, authType = authType, shouldOverwrite = shouldOverwrite)
  output <- .codebuild$import_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$import_source_credentials <- codebuild_import_source_credentials

#' Resets the cache for a project
#'
#' @description
#' Resets the cache for a project.
#'
#' @usage
#' codebuild_invalidate_project_cache(projectName)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild build project that the cache is reset for.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$invalidate_project_cache(
#'   projectName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_invalidate_project_cache
codebuild_invalidate_project_cache <- function(projectName) {
  op <- new_operation(
    name = "InvalidateProjectCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$invalidate_project_cache_input(projectName = projectName)
  output <- .codebuild$invalidate_project_cache_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$invalidate_project_cache <- codebuild_invalidate_project_cache

#' Retrieves the identifiers of your build batches in the current region
#'
#' @description
#' Retrieves the identifiers of your build batches in the current region.
#'
#' @usage
#' codebuild_list_build_batches(filter, maxResults, sortOrder, nextToken)
#'
#' @param filter A `BuildBatchFilter` object that specifies the filters for the search.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies the sort order of the returned items. Valid values include:
#' 
#' -   `ASCENDING`: List the batch build identifiers in ascending order by
#'     identifier.
#' 
#' -   `DESCENDING`: List the batch build identifiers in descending order
#'     by identifier.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`list_build_batches`][codebuild_list_build_batches]. This specifies the
#' next item to return. To return the beginning of the list, exclude this
#' parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ids = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_build_batches(
#'   filter = list(
#'     status = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED"
#'   ),
#'   maxResults = 123,
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_build_batches
codebuild_list_build_batches <- function(filter = NULL, maxResults = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildBatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_build_batches_input(filter = filter, maxResults = maxResults, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_build_batches_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_build_batches <- codebuild_list_build_batches

#' Retrieves the identifiers of the build batches for a specific project
#'
#' @description
#' Retrieves the identifiers of the build batches for a specific project.
#'
#' @usage
#' codebuild_list_build_batches_for_project(projectName, filter,
#'   maxResults, sortOrder, nextToken)
#'
#' @param projectName The name of the project.
#' @param filter A `BuildBatchFilter` object that specifies the filters for the search.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies the sort order of the returned items. Valid values include:
#' 
#' -   `ASCENDING`: List the batch build identifiers in ascending order by
#'     identifier.
#' 
#' -   `DESCENDING`: List the batch build identifiers in descending order
#'     by identifier.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`list_build_batches_for_project`][codebuild_list_build_batches_for_project].
#' This specifies the next item to return. To return the beginning of the
#' list, exclude this parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ids = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_build_batches_for_project(
#'   projectName = "string",
#'   filter = list(
#'     status = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED"
#'   ),
#'   maxResults = 123,
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_build_batches_for_project
codebuild_list_build_batches_for_project <- function(projectName = NULL, filter = NULL, maxResults = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildBatchesForProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_build_batches_for_project_input(projectName = projectName, filter = filter, maxResults = maxResults, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_build_batches_for_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_build_batches_for_project <- codebuild_list_build_batches_for_project

#' Gets a list of build IDs, with each build ID representing a single build
#'
#' @description
#' Gets a list of build IDs, with each build ID representing a single
#' build.
#'
#' @usage
#' codebuild_list_builds(sortOrder, nextToken)
#'
#' @param sortOrder The order to list build IDs. Valid values include:
#' 
#' -   `ASCENDING`: List the build IDs in ascending order by build ID.
#' 
#' -   `DESCENDING`: List the build IDs in descending order by build ID.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ids = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_builds(
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_builds
codebuild_list_builds <- function(sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_builds_input(sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_builds <- codebuild_list_builds

#' Gets a list of build IDs for the specified build project, with each
#' build ID representing a single build
#'
#' @description
#' Gets a list of build IDs for the specified build project, with each
#' build ID representing a single build.
#'
#' @usage
#' codebuild_list_builds_for_project(projectName, sortOrder, nextToken)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild project.
#' @param sortOrder The order to list build IDs. Valid values include:
#' 
#' -   `ASCENDING`: List the build IDs in ascending order by build ID.
#' 
#' -   `DESCENDING`: List the build IDs in descending order by build ID.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ids = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_builds_for_project(
#'   projectName = "string",
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_builds_for_project
codebuild_list_builds_for_project <- function(projectName, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildsForProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_builds_for_project_input(projectName = projectName, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_builds_for_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_builds_for_project <- codebuild_list_builds_for_project

#' Gets information about Docker images that are managed by AWS CodeBuild
#'
#' @description
#' Gets information about Docker images that are managed by AWS CodeBuild.
#'
#' @usage
#' codebuild_list_curated_environment_images()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   platforms = list(
#'     list(
#'       platform = "DEBIAN"|"AMAZON_LINUX"|"UBUNTU"|"WINDOWS_SERVER",
#'       languages = list(
#'         list(
#'           language = "JAVA"|"PYTHON"|"NODE_JS"|"RUBY"|"GOLANG"|"DOCKER"|"ANDROID"|"DOTNET"|"BASE"|"PHP",
#'           images = list(
#'             list(
#'               name = "string",
#'               description = "string",
#'               versions = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_curated_environment_images()
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_curated_environment_images
codebuild_list_curated_environment_images <- function() {
  op <- new_operation(
    name = "ListCuratedEnvironmentImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_curated_environment_images_input()
  output <- .codebuild$list_curated_environment_images_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_curated_environment_images <- codebuild_list_curated_environment_images

#' Gets a list of build project names, with each build project name
#' representing a single build project
#'
#' @description
#' Gets a list of build project names, with each build project name
#' representing a single build project.
#'
#' @usage
#' codebuild_list_projects(sortBy, sortOrder, nextToken)
#'
#' @param sortBy The criterion to be used to list build project names. Valid values
#' include:
#' 
#' -   `CREATED_TIME`: List based on when each build project was created.
#' 
#' -   `LAST_MODIFIED_TIME`: List based on when information about each
#'     build project was last changed.
#' 
#' -   `NAME`: List based on each build project's name.
#' 
#' Use `sortOrder` to specify in what order to list the build project names
#' based on the preceding criteria.
#' @param sortOrder The order in which to list build projects. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' 
#' Use `sortBy` to specify the criterion to be used to list build project
#' names.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   projects = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_projects(
#'   sortBy = "NAME"|"CREATED_TIME"|"LAST_MODIFIED_TIME",
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_projects
codebuild_list_projects <- function(sortBy = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_projects_input(sortBy = sortBy, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_projects <- codebuild_list_projects

#' Gets a list ARNs for the report groups in the current AWS account
#'
#' @description
#' Gets a list ARNs for the report groups in the current AWS account.
#'
#' @usage
#' codebuild_list_report_groups(sortOrder, sortBy, nextToken, maxResults)
#'
#' @param sortOrder Used to specify the order to sort the list of returned report groups.
#' Valid values are `ASCENDING` and `DESCENDING`.
#' @param sortBy The criterion to be used to list build report groups. Valid values
#' include:
#' 
#' -   `CREATED_TIME`: List based on when each report group was created.
#' 
#' -   `LAST_MODIFIED_TIME`: List based on when each report group was last
#'     changed.
#' 
#' -   `NAME`: List based on each report group's name.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated report groups returned per response. Use
#' `nextToken` to iterate pages in the list of returned `ReportGroup`
#' objects. The default value is 100.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   reportGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_report_groups(
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   sortBy = "NAME"|"CREATED_TIME"|"LAST_MODIFIED_TIME",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_report_groups
codebuild_list_report_groups <- function(sortOrder = NULL, sortBy = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_report_groups_input(sortOrder = sortOrder, sortBy = sortBy, nextToken = nextToken, maxResults = maxResults)
  output <- .codebuild$list_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_report_groups <- codebuild_list_report_groups

#' Returns a list of ARNs for the reports in the current AWS account
#'
#' @description
#' Returns a list of ARNs for the reports in the current AWS account.
#'
#' @usage
#' codebuild_list_reports(sortOrder, nextToken, maxResults, filter)
#'
#' @param sortOrder Specifies the sort order for the list of returned reports. Valid values
#' are:
#' 
#' -   `ASCENDING`: return reports in chronological order based on their
#'     creation date.
#' 
#' -   `DESCENDING`: return reports in the reverse chronological order
#'     based on their creation date.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated reports returned per response. Use
#' `nextToken` to iterate pages in the list of returned `Report` objects.
#' The default value is 100.
#' @param filter A `ReportFilter` object used to filter the returned reports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   reports = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_reports(
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   nextToken = "string",
#'   maxResults = 123,
#'   filter = list(
#'     status = "GENERATING"|"SUCCEEDED"|"FAILED"|"INCOMPLETE"|"DELETING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_reports
codebuild_list_reports <- function(sortOrder = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_reports_input(sortOrder = sortOrder, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .codebuild$list_reports_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_reports <- codebuild_list_reports

#' Returns a list of ARNs for the reports that belong to a ReportGroup
#'
#' @description
#' Returns a list of ARNs for the reports that belong to a `ReportGroup`.
#'
#' @usage
#' codebuild_list_reports_for_report_group(reportGroupArn, nextToken,
#'   sortOrder, maxResults, filter)
#'
#' @param reportGroupArn &#91;required&#93; The ARN of the report group for which you want to return report ARNs.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param sortOrder Use to specify whether the results are returned in ascending or
#' descending order.
#' @param maxResults The maximum number of paginated reports in this report group returned
#' per response. Use `nextToken` to iterate pages in the list of returned
#' `Report` objects. The default value is 100.
#' @param filter A `ReportFilter` object used to filter the returned reports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   reports = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_reports_for_report_group(
#'   reportGroupArn = "string",
#'   nextToken = "string",
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   maxResults = 123,
#'   filter = list(
#'     status = "GENERATING"|"SUCCEEDED"|"FAILED"|"INCOMPLETE"|"DELETING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_reports_for_report_group
codebuild_list_reports_for_report_group <- function(reportGroupArn, nextToken = NULL, sortOrder = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReportsForReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_reports_for_report_group_input(reportGroupArn = reportGroupArn, nextToken = nextToken, sortOrder = sortOrder, maxResults = maxResults, filter = filter)
  output <- .codebuild$list_reports_for_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_reports_for_report_group <- codebuild_list_reports_for_report_group

#' Gets a list of projects that are shared with other AWS accounts or users
#'
#' @description
#' Gets a list of projects that are shared with other AWS accounts or
#' users.
#'
#' @usage
#' codebuild_list_shared_projects(sortBy, sortOrder, maxResults, nextToken)
#'
#' @param sortBy The criterion to be used to list build projects shared with the current
#' AWS account or user. Valid values include:
#' 
#' -   `ARN`: List based on the ARN.
#' 
#' -   `MODIFIED_TIME`: List based on when information about the shared
#'     project was last changed.
#' @param sortOrder The order in which to list shared build projects. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' @param maxResults The maximum number of paginated shared build projects returned per
#' response. Use `nextToken` to iterate pages in the list of returned
#' `Project` objects. The default value is 100.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   projects = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_shared_projects(
#'   sortBy = "ARN"|"MODIFIED_TIME",
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_shared_projects
codebuild_list_shared_projects <- function(sortBy = NULL, sortOrder = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSharedProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_shared_projects_input(sortBy = sortBy, sortOrder = sortOrder, maxResults = maxResults, nextToken = nextToken)
  output <- .codebuild$list_shared_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_shared_projects <- codebuild_list_shared_projects

#' Gets a list of report groups that are shared with other AWS accounts or
#' users
#'
#' @description
#' Gets a list of report groups that are shared with other AWS accounts or
#' users.
#'
#' @usage
#' codebuild_list_shared_report_groups(sortOrder, sortBy, nextToken,
#'   maxResults)
#'
#' @param sortOrder The order in which to list shared report groups. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' @param sortBy The criterion to be used to list report groups shared with the current
#' AWS account or user. Valid values include:
#' 
#' -   `ARN`: List based on the ARN.
#' 
#' -   `MODIFIED_TIME`: List based on when information about the shared
#'     report group was last changed.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated shared report groups per response. Use
#' `nextToken` to iterate pages in the list of returned `ReportGroup`
#' objects. The default value is 100.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   reportGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_shared_report_groups(
#'   sortOrder = "ASCENDING"|"DESCENDING",
#'   sortBy = "ARN"|"MODIFIED_TIME",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_shared_report_groups
codebuild_list_shared_report_groups <- function(sortOrder = NULL, sortBy = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSharedReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_shared_report_groups_input(sortOrder = sortOrder, sortBy = sortBy, nextToken = nextToken, maxResults = maxResults)
  output <- .codebuild$list_shared_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_shared_report_groups <- codebuild_list_shared_report_groups

#' Returns a list of SourceCredentialsInfo objects
#'
#' @description
#' Returns a list of `SourceCredentialsInfo` objects.
#'
#' @usage
#' codebuild_list_source_credentials()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   sourceCredentialsInfos = list(
#'     list(
#'       arn = "string",
#'       serverType = "GITHUB"|"BITBUCKET"|"GITHUB_ENTERPRISE",
#'       authType = "OAUTH"|"BASIC_AUTH"|"PERSONAL_ACCESS_TOKEN"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_source_credentials()
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_list_source_credentials
codebuild_list_source_credentials <- function() {
  op <- new_operation(
    name = "ListSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_source_credentials_input()
  output <- .codebuild$list_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_source_credentials <- codebuild_list_source_credentials

#' Stores a resource policy for the ARN of a Project or ReportGroup object
#'
#' @description
#' Stores a resource policy for the ARN of a `Project` or `ReportGroup`
#' object.
#'
#' @usage
#' codebuild_put_resource_policy(policy, resourceArn)
#'
#' @param policy &#91;required&#93; A JSON-formatted resource policy. For more information, see [Sharing a
#' Project](https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share)
#' and [Sharing a Report
#' Group](https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share)
#' in the *AWS CodeBuild User Guide*.
#' @param resourceArn &#91;required&#93; The ARN of the `Project` or `ReportGroup` resource you want to associate
#' with a resource policy.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_policy(
#'   policy = "string",
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_put_resource_policy
codebuild_put_resource_policy <- function(policy, resourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$put_resource_policy_input(policy = policy, resourceArn = resourceArn)
  output <- .codebuild$put_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$put_resource_policy <- codebuild_put_resource_policy

#' Restarts a build
#'
#' @description
#' Restarts a build.
#'
#' @usage
#' codebuild_retry_build(id, idempotencyToken)
#'
#' @param id Specifies the identifier of the build to restart.
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`retry_build`][codebuild_retry_build] request. The
#' token is included in the [`retry_build`][codebuild_retry_build] request
#' and is valid for five minutes. If you repeat the
#' [`retry_build`][codebuild_retry_build] request with the same token, but
#' change a parameter, AWS CodeBuild returns a parameter mismatch error.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   build = list(
#'     id = "string",
#'     arn = "string",
#'     buildNumber = 123,
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"QUEUED"|"PROVISIONING"|"DOWNLOAD_SOURCE"|"INSTALL"|"PRE_BUILD"|"BUILD"|"POST_BUILD"|"UPLOAD_ARTIFACTS"|"FINALIZING"|"COMPLETED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logs = list(
#'       groupName = "string",
#'       streamName = "string",
#'       deepLink = "string",
#'       s3DeepLink = "string",
#'       cloudWatchLogsArn = "string",
#'       s3LogsArn = "string",
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     timeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     buildComplete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     networkInterface = list(
#'       subnetId = "string",
#'       networkInterfaceId = "string"
#'     ),
#'     encryptionKey = "string",
#'     exportedEnvironmentVariables = list(
#'       list(
#'         name = "string",
#'         value = "string"
#'       )
#'     ),
#'     reportArns = list(
#'       "string"
#'     ),
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     debugSession = list(
#'       sessionEnabled = TRUE|FALSE,
#'       sessionTarget = "string"
#'     ),
#'     buildBatchArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$retry_build(
#'   id = "string",
#'   idempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_retry_build
codebuild_retry_build <- function(id = NULL, idempotencyToken = NULL) {
  op <- new_operation(
    name = "RetryBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$retry_build_input(id = id, idempotencyToken = idempotencyToken)
  output <- .codebuild$retry_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$retry_build <- codebuild_retry_build

#' Restarts a failed batch build
#'
#' @description
#' Restarts a failed batch build. Only batch builds that have failed can be
#' retried.
#'
#' @usage
#' codebuild_retry_build_batch(id, idempotencyToken, retryType)
#'
#' @param id Specifies the identifier of the batch build to restart.
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`retry_build_batch`][codebuild_retry_build_batch]
#' request. The token is included in the
#' [`retry_build_batch`][codebuild_retry_build_batch] request and is valid
#' for five minutes. If you repeat the
#' [`retry_build_batch`][codebuild_retry_build_batch] request with the same
#' token, but change a parameter, AWS CodeBuild returns a parameter
#' mismatch error.
#' @param retryType Specifies the type of retry to perform.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   buildBatch = list(
#'     id = "string",
#'     arn = "string",
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildBatchStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"DOWNLOAD_BATCHSPEC"|"IN_PROGRESS"|"COMBINE_ARTIFACTS"|"SUCCEEDED"|"FAILED"|"STOPPED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logConfig = list(
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     buildTimeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     complete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     encryptionKey = "string",
#'     buildBatchNumber = 123,
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     buildBatchConfig = list(
#'       serviceRole = "string",
#'       combineArtifacts = TRUE|FALSE,
#'       restrictions = list(
#'         maximumBuildsAllowed = 123,
#'         computeTypesAllowed = list(
#'           "string"
#'         )
#'       ),
#'       timeoutInMins = 123
#'     ),
#'     buildGroups = list(
#'       list(
#'         identifier = "string",
#'         dependsOn = list(
#'           "string"
#'         ),
#'         ignoreFailure = TRUE|FALSE,
#'         currentBuildSummary = list(
#'           arn = "string",
#'           requestedOn = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'           primaryArtifact = list(
#'             type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'             location = "string",
#'             identifier = "string"
#'           ),
#'           secondaryArtifacts = list(
#'             list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             )
#'           )
#'         ),
#'         priorBuildSummaryList = list(
#'           list(
#'             arn = "string",
#'             requestedOn = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'             primaryArtifact = list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             ),
#'             secondaryArtifacts = list(
#'               list(
#'                 type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                 location = "string",
#'                 identifier = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$retry_build_batch(
#'   id = "string",
#'   idempotencyToken = "string",
#'   retryType = "RETRY_ALL_BUILDS"|"RETRY_FAILED_BUILDS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_retry_build_batch
codebuild_retry_build_batch <- function(id = NULL, idempotencyToken = NULL, retryType = NULL) {
  op <- new_operation(
    name = "RetryBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$retry_build_batch_input(id = id, idempotencyToken = idempotencyToken, retryType = retryType)
  output <- .codebuild$retry_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$retry_build_batch <- codebuild_retry_build_batch

#' Starts running a build
#'
#' @description
#' Starts running a build.
#'
#' @usage
#' codebuild_start_build(projectName, secondarySourcesOverride,
#'   secondarySourcesVersionOverride, sourceVersion, artifactsOverride,
#'   secondaryArtifactsOverride, environmentVariablesOverride,
#'   sourceTypeOverride, sourceLocationOverride, sourceAuthOverride,
#'   gitCloneDepthOverride, gitSubmodulesConfigOverride, buildspecOverride,
#'   insecureSslOverride, reportBuildStatusOverride,
#'   buildStatusConfigOverride, environmentTypeOverride, imageOverride,
#'   computeTypeOverride, certificateOverride, cacheOverride,
#'   serviceRoleOverride, privilegedModeOverride, timeoutInMinutesOverride,
#'   queuedTimeoutInMinutesOverride, encryptionKeyOverride, idempotencyToken,
#'   logsConfigOverride, registryCredentialOverride,
#'   imagePullCredentialsTypeOverride, debugSessionEnabled)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild build project to start running a build.
#' @param secondarySourcesOverride An array of `ProjectSource` objects.
#' @param secondarySourcesVersionOverride An array of `ProjectSourceVersion` objects that specify one or more
#' versions of the project's secondary sources to be used for this build
#' only.
#' @param sourceVersion The version of the build input to be built, for this build only. If not
#' specified, the latest version is used. If specified, the contents
#' depends on the source provider:
#' 
#' ### AWS CodeCommit
#' 
#' The commit ID, branch, or Git tag to use.
#' 
#' ### GitHub
#' 
#' The commit ID, pull request ID, branch name, or tag name that
#' corresponds to the version of the source code you want to build. If a
#' pull request ID is specified, it must use the format
#' `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#' specified, the branch's HEAD commit ID is used. If not specified, the
#' default branch's HEAD commit ID is used.
#' 
#' ### Bitbucket
#' 
#' The commit ID, branch name, or tag name that corresponds to the version
#' of the source code you want to build. If a branch name is specified, the
#' branch's HEAD commit ID is used. If not specified, the default branch's
#' HEAD commit ID is used.
#' 
#' ### Amazon Simple Storage Service (Amazon S3)
#' 
#' The version ID of the object that represents the build input ZIP file to
#' use.
#' 
#' If `sourceVersion` is specified at the project level, then this
#' `sourceVersion` (at the build level) takes precedence.
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *AWS CodeBuild User Guide*.
#' @param artifactsOverride Build output artifact settings that override, for this build only, the
#' latest ones already defined in the build project.
#' @param secondaryArtifactsOverride An array of `ProjectArtifacts` objects.
#' @param environmentVariablesOverride A set of environment variables that overrides, for this build only, the
#' latest ones already defined in the build project.
#' @param sourceTypeOverride A source input type, for this build, that overrides the source input
#' defined in the build project.
#' @param sourceLocationOverride A location that overrides, for this build, the source location for the
#' one defined in the build project.
#' @param sourceAuthOverride An authorization type for this build that overrides the one defined in
#' the build project. This override applies only if the build project's
#' source is BitBucket or GitHub.
#' @param gitCloneDepthOverride The user-defined depth of history, with a minimum value of 0, that
#' overrides, for this build only, any previous depth of history defined in
#' the build project.
#' @param gitSubmodulesConfigOverride Information about the Git submodules configuration for this build of an
#' AWS CodeBuild build project.
#' @param buildspecOverride A buildspec file declaration that overrides, for this build only, the
#' latest one already defined in the build project.
#' 
#' If this value is set, it can be either an inline buildspec definition,
#' the path to an alternate buildspec file relative to the value of the
#' built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3
#' bucket. The bucket must be in the same AWS Region as the build project.
#' Specify the buildspec file using its ARN (for example,
#' `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not
#' provided or is set to an empty string, the source code must contain a
#' buildspec file in its root directory. For more information, see
#' [Buildspec File Name and Storage
#' Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
#' @param insecureSslOverride Enable this flag to override the insecure SSL setting that is specified
#' in the build project. The insecure SSL setting determines whether to
#' ignore SSL warnings while connecting to the project source code. This
#' override applies only if the build's source is GitHub Enterprise.
#' @param reportBuildStatusOverride Set to true to report to your source provider the status of a build's
#' start and completion. If you use this option with a source provider
#' other than GitHub, GitHub Enterprise, or Bitbucket, an
#' invalidInputException is thrown.
#' 
#' The status of a build triggered by a webhook is always reported to your
#' source provider.
#' @param buildStatusConfigOverride Contains information that defines how the build project reports the
#' build status to the source provider. This option is only used when the
#' source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
#' @param environmentTypeOverride A container type for this build that overrides the one specified in the
#' build project.
#' @param imageOverride The name of an image for this build that overrides the one specified in
#' the build project.
#' @param computeTypeOverride The name of a compute type for this build that overrides the one
#' specified in the build project.
#' @param certificateOverride The name of a certificate for this build that overrides the one
#' specified in the build project.
#' @param cacheOverride A ProjectCache object specified for this build that overrides the one
#' defined in the build project.
#' @param serviceRoleOverride The name of a service role for this build that overrides the one
#' specified in the build project.
#' @param privilegedModeOverride Enable this flag to override privileged mode in the build project.
#' @param timeoutInMinutesOverride The number of build timeout minutes, from 5 to 480 (8 hours), that
#' overrides, for this build only, the latest setting already defined in
#' the build project.
#' @param queuedTimeoutInMinutesOverride The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKeyOverride The AWS Key Management Service (AWS KMS) customer master key (CMK) that
#' overrides the one specified in the build project. The CMK key encrypts
#' the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the StartBuild request. The token is included in the
#' StartBuild request and is valid for 5 minutes. If you repeat the
#' StartBuild request with the same token, but change a parameter, AWS
#' CodeBuild returns a parameter mismatch error.
#' @param logsConfigOverride Log settings for this build that override the log settings defined in
#' the build project.
#' @param registryCredentialOverride The credentials for access to a private registry.
#' @param imagePullCredentialsTypeOverride The type of credentials AWS CodeBuild uses to pull images in your build.
#' There are two valid values:
#' 
#' ### CODEBUILD
#' 
#' Specifies that AWS CodeBuild uses its own credentials. This requires
#' that you modify your ECR repository policy to trust AWS CodeBuild's
#' service principal.
#' 
#' ### SERVICE_ROLE
#' 
#' Specifies that AWS CodeBuild uses your build project's service role.
#' 
#' When using a cross-account or private registry image, you must use
#' `SERVICE_ROLE` credentials. When using an AWS CodeBuild curated image,
#' you must use `CODEBUILD` credentials.
#' @param debugSessionEnabled Specifies if session debugging is enabled for this build. For more
#' information, see [Viewing a running build in Session
#' Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   build = list(
#'     id = "string",
#'     arn = "string",
#'     buildNumber = 123,
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"QUEUED"|"PROVISIONING"|"DOWNLOAD_SOURCE"|"INSTALL"|"PRE_BUILD"|"BUILD"|"POST_BUILD"|"UPLOAD_ARTIFACTS"|"FINALIZING"|"COMPLETED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logs = list(
#'       groupName = "string",
#'       streamName = "string",
#'       deepLink = "string",
#'       s3DeepLink = "string",
#'       cloudWatchLogsArn = "string",
#'       s3LogsArn = "string",
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     timeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     buildComplete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     networkInterface = list(
#'       subnetId = "string",
#'       networkInterfaceId = "string"
#'     ),
#'     encryptionKey = "string",
#'     exportedEnvironmentVariables = list(
#'       list(
#'         name = "string",
#'         value = "string"
#'       )
#'     ),
#'     reportArns = list(
#'       "string"
#'     ),
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     debugSession = list(
#'       sessionEnabled = TRUE|FALSE,
#'       sessionTarget = "string"
#'     ),
#'     buildBatchArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_build(
#'   projectName = "string",
#'   secondarySourcesOverride = list(
#'     list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     )
#'   ),
#'   secondarySourcesVersionOverride = list(
#'     list(
#'       sourceIdentifier = "string",
#'       sourceVersion = "string"
#'     )
#'   ),
#'   sourceVersion = "string",
#'   artifactsOverride = list(
#'     type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'     location = "string",
#'     path = "string",
#'     namespaceType = "NONE"|"BUILD_ID",
#'     name = "string",
#'     packaging = "NONE"|"ZIP",
#'     overrideArtifactName = TRUE|FALSE,
#'     encryptionDisabled = TRUE|FALSE,
#'     artifactIdentifier = "string"
#'   ),
#'   secondaryArtifactsOverride = list(
#'     list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     )
#'   ),
#'   environmentVariablesOverride = list(
#'     list(
#'       name = "string",
#'       value = "string",
#'       type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'     )
#'   ),
#'   sourceTypeOverride = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'   sourceLocationOverride = "string",
#'   sourceAuthOverride = list(
#'     type = "OAUTH",
#'     resource = "string"
#'   ),
#'   gitCloneDepthOverride = 123,
#'   gitSubmodulesConfigOverride = list(
#'     fetchSubmodules = TRUE|FALSE
#'   ),
#'   buildspecOverride = "string",
#'   insecureSslOverride = TRUE|FALSE,
#'   reportBuildStatusOverride = TRUE|FALSE,
#'   buildStatusConfigOverride = list(
#'     context = "string",
#'     targetUrl = "string"
#'   ),
#'   environmentTypeOverride = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'   imageOverride = "string",
#'   computeTypeOverride = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'   certificateOverride = "string",
#'   cacheOverride = list(
#'     type = "NO_CACHE"|"S3"|"LOCAL",
#'     location = "string",
#'     modes = list(
#'       "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'     )
#'   ),
#'   serviceRoleOverride = "string",
#'   privilegedModeOverride = TRUE|FALSE,
#'   timeoutInMinutesOverride = 123,
#'   queuedTimeoutInMinutesOverride = 123,
#'   encryptionKeyOverride = "string",
#'   idempotencyToken = "string",
#'   logsConfigOverride = list(
#'     cloudWatchLogs = list(
#'       status = "ENABLED"|"DISABLED",
#'       groupName = "string",
#'       streamName = "string"
#'     ),
#'     s3Logs = list(
#'       status = "ENABLED"|"DISABLED",
#'       location = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   registryCredentialOverride = list(
#'     credential = "string",
#'     credentialProvider = "SECRETS_MANAGER"
#'   ),
#'   imagePullCredentialsTypeOverride = "CODEBUILD"|"SERVICE_ROLE",
#'   debugSessionEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_start_build
codebuild_start_build <- function(projectName, secondarySourcesOverride = NULL, secondarySourcesVersionOverride = NULL, sourceVersion = NULL, artifactsOverride = NULL, secondaryArtifactsOverride = NULL, environmentVariablesOverride = NULL, sourceTypeOverride = NULL, sourceLocationOverride = NULL, sourceAuthOverride = NULL, gitCloneDepthOverride = NULL, gitSubmodulesConfigOverride = NULL, buildspecOverride = NULL, insecureSslOverride = NULL, reportBuildStatusOverride = NULL, buildStatusConfigOverride = NULL, environmentTypeOverride = NULL, imageOverride = NULL, computeTypeOverride = NULL, certificateOverride = NULL, cacheOverride = NULL, serviceRoleOverride = NULL, privilegedModeOverride = NULL, timeoutInMinutesOverride = NULL, queuedTimeoutInMinutesOverride = NULL, encryptionKeyOverride = NULL, idempotencyToken = NULL, logsConfigOverride = NULL, registryCredentialOverride = NULL, imagePullCredentialsTypeOverride = NULL, debugSessionEnabled = NULL) {
  op <- new_operation(
    name = "StartBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$start_build_input(projectName = projectName, secondarySourcesOverride = secondarySourcesOverride, secondarySourcesVersionOverride = secondarySourcesVersionOverride, sourceVersion = sourceVersion, artifactsOverride = artifactsOverride, secondaryArtifactsOverride = secondaryArtifactsOverride, environmentVariablesOverride = environmentVariablesOverride, sourceTypeOverride = sourceTypeOverride, sourceLocationOverride = sourceLocationOverride, sourceAuthOverride = sourceAuthOverride, gitCloneDepthOverride = gitCloneDepthOverride, gitSubmodulesConfigOverride = gitSubmodulesConfigOverride, buildspecOverride = buildspecOverride, insecureSslOverride = insecureSslOverride, reportBuildStatusOverride = reportBuildStatusOverride, buildStatusConfigOverride = buildStatusConfigOverride, environmentTypeOverride = environmentTypeOverride, imageOverride = imageOverride, computeTypeOverride = computeTypeOverride, certificateOverride = certificateOverride, cacheOverride = cacheOverride, serviceRoleOverride = serviceRoleOverride, privilegedModeOverride = privilegedModeOverride, timeoutInMinutesOverride = timeoutInMinutesOverride, queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride, encryptionKeyOverride = encryptionKeyOverride, idempotencyToken = idempotencyToken, logsConfigOverride = logsConfigOverride, registryCredentialOverride = registryCredentialOverride, imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride, debugSessionEnabled = debugSessionEnabled)
  output <- .codebuild$start_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$start_build <- codebuild_start_build

#' Starts a batch build for a project
#'
#' @description
#' Starts a batch build for a project.
#'
#' @usage
#' codebuild_start_build_batch(projectName, secondarySourcesOverride,
#'   secondarySourcesVersionOverride, sourceVersion, artifactsOverride,
#'   secondaryArtifactsOverride, environmentVariablesOverride,
#'   sourceTypeOverride, sourceLocationOverride, sourceAuthOverride,
#'   gitCloneDepthOverride, gitSubmodulesConfigOverride, buildspecOverride,
#'   insecureSslOverride, reportBuildBatchStatusOverride,
#'   environmentTypeOverride, imageOverride, computeTypeOverride,
#'   certificateOverride, cacheOverride, serviceRoleOverride,
#'   privilegedModeOverride, buildTimeoutInMinutesOverride,
#'   queuedTimeoutInMinutesOverride, encryptionKeyOverride, idempotencyToken,
#'   logsConfigOverride, registryCredentialOverride,
#'   imagePullCredentialsTypeOverride, buildBatchConfigOverride)
#'
#' @param projectName &#91;required&#93; The name of the project.
#' @param secondarySourcesOverride An array of `ProjectSource` objects that override the secondary sources
#' defined in the batch build project.
#' @param secondarySourcesVersionOverride An array of `ProjectSourceVersion` objects that override the secondary
#' source versions in the batch build project.
#' @param sourceVersion The version of the batch build input to be built, for this build only.
#' If not specified, the latest version is used. If specified, the contents
#' depends on the source provider:
#' 
#' ### AWS CodeCommit
#' 
#' The commit ID, branch, or Git tag to use.
#' 
#' ### GitHub
#' 
#' The commit ID, pull request ID, branch name, or tag name that
#' corresponds to the version of the source code you want to build. If a
#' pull request ID is specified, it must use the format
#' `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#' specified, the branch's HEAD commit ID is used. If not specified, the
#' default branch's HEAD commit ID is used.
#' 
#' ### Bitbucket
#' 
#' The commit ID, branch name, or tag name that corresponds to the version
#' of the source code you want to build. If a branch name is specified, the
#' branch's HEAD commit ID is used. If not specified, the default branch's
#' HEAD commit ID is used.
#' 
#' ### Amazon Simple Storage Service (Amazon S3)
#' 
#' The version ID of the object that represents the build input ZIP file to
#' use.
#' 
#' If `sourceVersion` is specified at the project level, then this
#' `sourceVersion` (at the build level) takes precedence.
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *AWS CodeBuild User Guide*.
#' @param artifactsOverride An array of `ProjectArtifacts` objects that contains information about
#' the build output artifact overrides for the build project.
#' @param secondaryArtifactsOverride An array of `ProjectArtifacts` objects that override the secondary
#' artifacts defined in the batch build project.
#' @param environmentVariablesOverride An array of `EnvironmentVariable` objects that override, or add to, the
#' environment variables defined in the batch build project.
#' @param sourceTypeOverride The source input type that overrides the source input defined in the
#' batch build project.
#' @param sourceLocationOverride A location that overrides, for this batch build, the source location
#' defined in the batch build project.
#' @param sourceAuthOverride A `SourceAuth` object that overrides the one defined in the batch build
#' project. This override applies only if the build project's source is
#' BitBucket or GitHub.
#' @param gitCloneDepthOverride The user-defined depth of history, with a minimum value of 0, that
#' overrides, for this batch build only, any previous depth of history
#' defined in the batch build project.
#' @param gitSubmodulesConfigOverride A `GitSubmodulesConfig` object that overrides the Git submodules
#' configuration for this batch build.
#' @param buildspecOverride A buildspec file declaration that overrides, for this build only, the
#' latest one already defined in the build project.
#' 
#' If this value is set, it can be either an inline buildspec definition,
#' the path to an alternate buildspec file relative to the value of the
#' built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3
#' bucket. The bucket must be in the same AWS Region as the build project.
#' Specify the buildspec file using its ARN (for example,
#' `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not
#' provided or is set to an empty string, the source code must contain a
#' buildspec file in its root directory. For more information, see
#' [Buildspec File Name and Storage
#' Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
#' @param insecureSslOverride Enable this flag to override the insecure SSL setting that is specified
#' in the batch build project. The insecure SSL setting determines whether
#' to ignore SSL warnings while connecting to the project source code. This
#' override applies only if the build's source is GitHub Enterprise.
#' @param reportBuildBatchStatusOverride Set to `true` to report to your source provider the status of a batch
#' build's start and completion. If you use this option with a source
#' provider other than GitHub, GitHub Enterprise, or Bitbucket, an
#' `invalidInputException` is thrown.
#' 
#' The status of a build triggered by a webhook is always reported to your
#' source provider.
#' @param environmentTypeOverride A container type for this batch build that overrides the one specified
#' in the batch build project.
#' @param imageOverride The name of an image for this batch build that overrides the one
#' specified in the batch build project.
#' @param computeTypeOverride The name of a compute type for this batch build that overrides the one
#' specified in the batch build project.
#' @param certificateOverride The name of a certificate for this batch build that overrides the one
#' specified in the batch build project.
#' @param cacheOverride A `ProjectCache` object that specifies cache overrides.
#' @param serviceRoleOverride The name of a service role for this batch build that overrides the one
#' specified in the batch build project.
#' @param privilegedModeOverride Enable this flag to override privileged mode in the batch build project.
#' @param buildTimeoutInMinutesOverride Overrides the build timeout specified in the batch build project.
#' @param queuedTimeoutInMinutesOverride The number of minutes a batch build is allowed to be queued before it
#' times out.
#' @param encryptionKeyOverride The AWS Key Management Service (AWS KMS) customer master key (CMK) that
#' overrides the one specified in the batch build project. The CMK key
#' encrypts the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`start_build_batch`][codebuild_start_build_batch]
#' request. The token is included in the
#' [`start_build_batch`][codebuild_start_build_batch] request and is valid
#' for five minutes. If you repeat the
#' [`start_build_batch`][codebuild_start_build_batch] request with the same
#' token, but change a parameter, AWS CodeBuild returns a parameter
#' mismatch error.
#' @param logsConfigOverride A `LogsConfig` object that override the log settings defined in the
#' batch build project.
#' @param registryCredentialOverride A `RegistryCredential` object that overrides credentials for access to a
#' private registry.
#' @param imagePullCredentialsTypeOverride The type of credentials AWS CodeBuild uses to pull images in your batch
#' build. There are two valid values:
#' 
#' ### CODEBUILD
#' 
#' Specifies that AWS CodeBuild uses its own credentials. This requires
#' that you modify your ECR repository policy to trust AWS CodeBuild's
#' service principal.
#' 
#' ### SERVICE_ROLE
#' 
#' Specifies that AWS CodeBuild uses your build project's service role.
#' 
#' When using a cross-account or private registry image, you must use
#' `SERVICE_ROLE` credentials. When using an AWS CodeBuild curated image,
#' you must use `CODEBUILD` credentials.
#' @param buildBatchConfigOverride A `BuildBatchConfigOverride` object that contains batch build
#' configuration overrides.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   buildBatch = list(
#'     id = "string",
#'     arn = "string",
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildBatchStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"DOWNLOAD_BATCHSPEC"|"IN_PROGRESS"|"COMBINE_ARTIFACTS"|"SUCCEEDED"|"FAILED"|"STOPPED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logConfig = list(
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     buildTimeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     complete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     encryptionKey = "string",
#'     buildBatchNumber = 123,
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     buildBatchConfig = list(
#'       serviceRole = "string",
#'       combineArtifacts = TRUE|FALSE,
#'       restrictions = list(
#'         maximumBuildsAllowed = 123,
#'         computeTypesAllowed = list(
#'           "string"
#'         )
#'       ),
#'       timeoutInMins = 123
#'     ),
#'     buildGroups = list(
#'       list(
#'         identifier = "string",
#'         dependsOn = list(
#'           "string"
#'         ),
#'         ignoreFailure = TRUE|FALSE,
#'         currentBuildSummary = list(
#'           arn = "string",
#'           requestedOn = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'           primaryArtifact = list(
#'             type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'             location = "string",
#'             identifier = "string"
#'           ),
#'           secondaryArtifacts = list(
#'             list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             )
#'           )
#'         ),
#'         priorBuildSummaryList = list(
#'           list(
#'             arn = "string",
#'             requestedOn = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'             primaryArtifact = list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             ),
#'             secondaryArtifacts = list(
#'               list(
#'                 type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                 location = "string",
#'                 identifier = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_build_batch(
#'   projectName = "string",
#'   secondarySourcesOverride = list(
#'     list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     )
#'   ),
#'   secondarySourcesVersionOverride = list(
#'     list(
#'       sourceIdentifier = "string",
#'       sourceVersion = "string"
#'     )
#'   ),
#'   sourceVersion = "string",
#'   artifactsOverride = list(
#'     type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'     location = "string",
#'     path = "string",
#'     namespaceType = "NONE"|"BUILD_ID",
#'     name = "string",
#'     packaging = "NONE"|"ZIP",
#'     overrideArtifactName = TRUE|FALSE,
#'     encryptionDisabled = TRUE|FALSE,
#'     artifactIdentifier = "string"
#'   ),
#'   secondaryArtifactsOverride = list(
#'     list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     )
#'   ),
#'   environmentVariablesOverride = list(
#'     list(
#'       name = "string",
#'       value = "string",
#'       type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'     )
#'   ),
#'   sourceTypeOverride = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'   sourceLocationOverride = "string",
#'   sourceAuthOverride = list(
#'     type = "OAUTH",
#'     resource = "string"
#'   ),
#'   gitCloneDepthOverride = 123,
#'   gitSubmodulesConfigOverride = list(
#'     fetchSubmodules = TRUE|FALSE
#'   ),
#'   buildspecOverride = "string",
#'   insecureSslOverride = TRUE|FALSE,
#'   reportBuildBatchStatusOverride = TRUE|FALSE,
#'   environmentTypeOverride = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'   imageOverride = "string",
#'   computeTypeOverride = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'   certificateOverride = "string",
#'   cacheOverride = list(
#'     type = "NO_CACHE"|"S3"|"LOCAL",
#'     location = "string",
#'     modes = list(
#'       "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'     )
#'   ),
#'   serviceRoleOverride = "string",
#'   privilegedModeOverride = TRUE|FALSE,
#'   buildTimeoutInMinutesOverride = 123,
#'   queuedTimeoutInMinutesOverride = 123,
#'   encryptionKeyOverride = "string",
#'   idempotencyToken = "string",
#'   logsConfigOverride = list(
#'     cloudWatchLogs = list(
#'       status = "ENABLED"|"DISABLED",
#'       groupName = "string",
#'       streamName = "string"
#'     ),
#'     s3Logs = list(
#'       status = "ENABLED"|"DISABLED",
#'       location = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   registryCredentialOverride = list(
#'     credential = "string",
#'     credentialProvider = "SECRETS_MANAGER"
#'   ),
#'   imagePullCredentialsTypeOverride = "CODEBUILD"|"SERVICE_ROLE",
#'   buildBatchConfigOverride = list(
#'     serviceRole = "string",
#'     combineArtifacts = TRUE|FALSE,
#'     restrictions = list(
#'       maximumBuildsAllowed = 123,
#'       computeTypesAllowed = list(
#'         "string"
#'       )
#'     ),
#'     timeoutInMins = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_start_build_batch
codebuild_start_build_batch <- function(projectName, secondarySourcesOverride = NULL, secondarySourcesVersionOverride = NULL, sourceVersion = NULL, artifactsOverride = NULL, secondaryArtifactsOverride = NULL, environmentVariablesOverride = NULL, sourceTypeOverride = NULL, sourceLocationOverride = NULL, sourceAuthOverride = NULL, gitCloneDepthOverride = NULL, gitSubmodulesConfigOverride = NULL, buildspecOverride = NULL, insecureSslOverride = NULL, reportBuildBatchStatusOverride = NULL, environmentTypeOverride = NULL, imageOverride = NULL, computeTypeOverride = NULL, certificateOverride = NULL, cacheOverride = NULL, serviceRoleOverride = NULL, privilegedModeOverride = NULL, buildTimeoutInMinutesOverride = NULL, queuedTimeoutInMinutesOverride = NULL, encryptionKeyOverride = NULL, idempotencyToken = NULL, logsConfigOverride = NULL, registryCredentialOverride = NULL, imagePullCredentialsTypeOverride = NULL, buildBatchConfigOverride = NULL) {
  op <- new_operation(
    name = "StartBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$start_build_batch_input(projectName = projectName, secondarySourcesOverride = secondarySourcesOverride, secondarySourcesVersionOverride = secondarySourcesVersionOverride, sourceVersion = sourceVersion, artifactsOverride = artifactsOverride, secondaryArtifactsOverride = secondaryArtifactsOverride, environmentVariablesOverride = environmentVariablesOverride, sourceTypeOverride = sourceTypeOverride, sourceLocationOverride = sourceLocationOverride, sourceAuthOverride = sourceAuthOverride, gitCloneDepthOverride = gitCloneDepthOverride, gitSubmodulesConfigOverride = gitSubmodulesConfigOverride, buildspecOverride = buildspecOverride, insecureSslOverride = insecureSslOverride, reportBuildBatchStatusOverride = reportBuildBatchStatusOverride, environmentTypeOverride = environmentTypeOverride, imageOverride = imageOverride, computeTypeOverride = computeTypeOverride, certificateOverride = certificateOverride, cacheOverride = cacheOverride, serviceRoleOverride = serviceRoleOverride, privilegedModeOverride = privilegedModeOverride, buildTimeoutInMinutesOverride = buildTimeoutInMinutesOverride, queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride, encryptionKeyOverride = encryptionKeyOverride, idempotencyToken = idempotencyToken, logsConfigOverride = logsConfigOverride, registryCredentialOverride = registryCredentialOverride, imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride, buildBatchConfigOverride = buildBatchConfigOverride)
  output <- .codebuild$start_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$start_build_batch <- codebuild_start_build_batch

#' Attempts to stop running a build
#'
#' @description
#' Attempts to stop running a build.
#'
#' @usage
#' codebuild_stop_build(id)
#'
#' @param id &#91;required&#93; The ID of the build.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   build = list(
#'     id = "string",
#'     arn = "string",
#'     buildNumber = 123,
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"QUEUED"|"PROVISIONING"|"DOWNLOAD_SOURCE"|"INSTALL"|"PRE_BUILD"|"BUILD"|"POST_BUILD"|"UPLOAD_ARTIFACTS"|"FINALIZING"|"COMPLETED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logs = list(
#'       groupName = "string",
#'       streamName = "string",
#'       deepLink = "string",
#'       s3DeepLink = "string",
#'       cloudWatchLogsArn = "string",
#'       s3LogsArn = "string",
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     timeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     buildComplete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     networkInterface = list(
#'       subnetId = "string",
#'       networkInterfaceId = "string"
#'     ),
#'     encryptionKey = "string",
#'     exportedEnvironmentVariables = list(
#'       list(
#'         name = "string",
#'         value = "string"
#'       )
#'     ),
#'     reportArns = list(
#'       "string"
#'     ),
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     debugSession = list(
#'       sessionEnabled = TRUE|FALSE,
#'       sessionTarget = "string"
#'     ),
#'     buildBatchArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_build(
#'   id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_stop_build
codebuild_stop_build <- function(id) {
  op <- new_operation(
    name = "StopBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$stop_build_input(id = id)
  output <- .codebuild$stop_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$stop_build <- codebuild_stop_build

#' Stops a running batch build
#'
#' @description
#' Stops a running batch build.
#'
#' @usage
#' codebuild_stop_build_batch(id)
#'
#' @param id &#91;required&#93; The identifier of the batch build to stop.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   buildBatch = list(
#'     id = "string",
#'     arn = "string",
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     endTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     currentPhase = "string",
#'     buildBatchStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'     sourceVersion = "string",
#'     resolvedSourceVersion = "string",
#'     projectName = "string",
#'     phases = list(
#'       list(
#'         phaseType = "SUBMITTED"|"DOWNLOAD_BATCHSPEC"|"IN_PROGRESS"|"COMBINE_ARTIFACTS"|"SUCCEEDED"|"FAILED"|"STOPPED",
#'         phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         durationInSeconds = 123,
#'         contexts = list(
#'           list(
#'             statusCode = "string",
#'             message = "string"
#'           )
#'         )
#'       )
#'     ),
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       location = "string",
#'       sha256sum = "string",
#'       md5sum = "string",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         location = "string",
#'         sha256sum = "string",
#'         md5sum = "string",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     logConfig = list(
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     buildTimeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     complete = TRUE|FALSE,
#'     initiator = "string",
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     encryptionKey = "string",
#'     buildBatchNumber = 123,
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     buildBatchConfig = list(
#'       serviceRole = "string",
#'       combineArtifacts = TRUE|FALSE,
#'       restrictions = list(
#'         maximumBuildsAllowed = 123,
#'         computeTypesAllowed = list(
#'           "string"
#'         )
#'       ),
#'       timeoutInMins = 123
#'     ),
#'     buildGroups = list(
#'       list(
#'         identifier = "string",
#'         dependsOn = list(
#'           "string"
#'         ),
#'         ignoreFailure = TRUE|FALSE,
#'         currentBuildSummary = list(
#'           arn = "string",
#'           requestedOn = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'           primaryArtifact = list(
#'             type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'             location = "string",
#'             identifier = "string"
#'           ),
#'           secondaryArtifacts = list(
#'             list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             )
#'           )
#'         ),
#'         priorBuildSummaryList = list(
#'           list(
#'             arn = "string",
#'             requestedOn = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
#'             primaryArtifact = list(
#'               type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'               location = "string",
#'               identifier = "string"
#'             ),
#'             secondaryArtifacts = list(
#'               list(
#'                 type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'                 location = "string",
#'                 identifier = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_build_batch(
#'   id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_stop_build_batch
codebuild_stop_build_batch <- function(id) {
  op <- new_operation(
    name = "StopBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$stop_build_batch_input(id = id)
  output <- .codebuild$stop_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$stop_build_batch <- codebuild_stop_build_batch

#' Changes the settings of a build project
#'
#' @description
#' Changes the settings of a build project.
#'
#' @usage
#' codebuild_update_project(name, description, source, secondarySources,
#'   sourceVersion, secondarySourceVersions, artifacts, secondaryArtifacts,
#'   cache, environment, serviceRole, timeoutInMinutes,
#'   queuedTimeoutInMinutes, encryptionKey, tags, vpcConfig, badgeEnabled,
#'   logsConfig, fileSystemLocations, buildBatchConfig)
#'
#' @param name &#91;required&#93; The name of the build project.
#' 
#' You cannot change a build project's name.
#' @param description A new or replacement description of the build project.
#' @param source Information to be changed about the build input source code for the
#' build project.
#' @param secondarySources An array of `ProjectSource` objects.
#' @param sourceVersion A version of the build input to be built for this project. If not
#' specified, the latest version is used. If specified, it must be one of:
#' 
#' -   For AWS CodeCommit: the commit ID, branch, or Git tag to use.
#' 
#' -   For GitHub: the commit ID, pull request ID, branch name, or tag name
#'     that corresponds to the version of the source code you want to
#'     build. If a pull request ID is specified, it must use the format
#'     `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#'     specified, the branch's HEAD commit ID is used. If not specified,
#'     the default branch's HEAD commit ID is used.
#' 
#' -   For Bitbucket: the commit ID, branch name, or tag name that
#'     corresponds to the version of the source code you want to build. If
#'     a branch name is specified, the branch's HEAD commit ID is used. If
#'     not specified, the default branch's HEAD commit ID is used.
#' 
#' -   For Amazon Simple Storage Service (Amazon S3): the version ID of the
#'     object that represents the build input ZIP file to use.
#' 
#' If `sourceVersion` is specified at the build level, then that version
#' takes precedence over this `sourceVersion` (at the project level).
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *AWS CodeBuild User Guide*.
#' @param secondarySourceVersions An array of `ProjectSourceVersion` objects. If `secondarySourceVersions`
#' is specified at the build level, then they take over these
#' `secondarySourceVersions` (at the project level).
#' @param artifacts Information to be changed about the build output artifacts for the build
#' project.
#' @param secondaryArtifacts An array of `ProjectSource` objects.
#' @param cache Stores recently used information so that it can be quickly accessed at a
#' later time.
#' @param environment Information to be changed about the build environment for the build
#' project.
#' @param serviceRole The replacement ARN of the AWS Identity and Access Management (IAM) role
#' that enables AWS CodeBuild to interact with dependent AWS services on
#' behalf of the AWS account.
#' @param timeoutInMinutes The replacement value in minutes, from 5 to 480 (8 hours), for AWS
#' CodeBuild to wait before timing out any related build that did not get
#' marked as completed.
#' @param queuedTimeoutInMinutes The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKey The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
#' used for encrypting the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param tags An updated list of tag key and value pairs associated with this build
#' project.
#' 
#' These tags are available for use by AWS services that support AWS
#' CodeBuild build project tags.
#' @param vpcConfig VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
#' @param badgeEnabled Set this to true to generate a publicly accessible URL for your
#' project's build badge.
#' @param logsConfig Information about logs for the build project. A project can create logs
#' in Amazon CloudWatch Logs, logs in an S3 bucket, or both.
#' @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build
#' project. A `ProjectFileSystemLocation` object specifies the
#' `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a
#' file system created using Amazon Elastic File System.
#' @param buildBatchConfig 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   project = list(
#'     name = "string",
#'     arn = "string",
#'     description = "string",
#'     source = list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     ),
#'     secondarySources = list(
#'       list(
#'         type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'         location = "string",
#'         gitCloneDepth = 123,
#'         gitSubmodulesConfig = list(
#'           fetchSubmodules = TRUE|FALSE
#'         ),
#'         buildspec = "string",
#'         auth = list(
#'           type = "OAUTH",
#'           resource = "string"
#'         ),
#'         reportBuildStatus = TRUE|FALSE,
#'         buildStatusConfig = list(
#'           context = "string",
#'           targetUrl = "string"
#'         ),
#'         insecureSsl = TRUE|FALSE,
#'         sourceIdentifier = "string"
#'       )
#'     ),
#'     sourceVersion = "string",
#'     secondarySourceVersions = list(
#'       list(
#'         sourceIdentifier = "string",
#'         sourceVersion = "string"
#'       )
#'     ),
#'     artifacts = list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     ),
#'     secondaryArtifacts = list(
#'       list(
#'         type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'         location = "string",
#'         path = "string",
#'         namespaceType = "NONE"|"BUILD_ID",
#'         name = "string",
#'         packaging = "NONE"|"ZIP",
#'         overrideArtifactName = TRUE|FALSE,
#'         encryptionDisabled = TRUE|FALSE,
#'         artifactIdentifier = "string"
#'       )
#'     ),
#'     cache = list(
#'       type = "NO_CACHE"|"S3"|"LOCAL",
#'       location = "string",
#'       modes = list(
#'         "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'       )
#'     ),
#'     environment = list(
#'       type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'       image = "string",
#'       computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'       environmentVariables = list(
#'         list(
#'           name = "string",
#'           value = "string",
#'           type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'         )
#'       ),
#'       privilegedMode = TRUE|FALSE,
#'       certificate = "string",
#'       registryCredential = list(
#'         credential = "string",
#'         credentialProvider = "SECRETS_MANAGER"
#'       ),
#'       imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'     ),
#'     serviceRole = "string",
#'     timeoutInMinutes = 123,
#'     queuedTimeoutInMinutes = 123,
#'     encryptionKey = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastModified = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     webhook = list(
#'       url = "string",
#'       payloadUrl = "string",
#'       secret = "string",
#'       branchFilter = "string",
#'       filterGroups = list(
#'         list(
#'           list(
#'             type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'             pattern = "string",
#'             excludeMatchedPattern = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       buildType = "BUILD"|"BUILD_BATCH",
#'       lastModifiedSecret = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     vpcConfig = list(
#'       vpcId = "string",
#'       subnets = list(
#'         "string"
#'       ),
#'       securityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     badge = list(
#'       badgeEnabled = TRUE|FALSE,
#'       badgeRequestUrl = "string"
#'     ),
#'     logsConfig = list(
#'       cloudWatchLogs = list(
#'         status = "ENABLED"|"DISABLED",
#'         groupName = "string",
#'         streamName = "string"
#'       ),
#'       s3Logs = list(
#'         status = "ENABLED"|"DISABLED",
#'         location = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     fileSystemLocations = list(
#'       list(
#'         type = "EFS",
#'         location = "string",
#'         mountPoint = "string",
#'         identifier = "string",
#'         mountOptions = "string"
#'       )
#'     ),
#'     buildBatchConfig = list(
#'       serviceRole = "string",
#'       combineArtifacts = TRUE|FALSE,
#'       restrictions = list(
#'         maximumBuildsAllowed = 123,
#'         computeTypesAllowed = list(
#'           "string"
#'         )
#'       ),
#'       timeoutInMins = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_project(
#'   name = "string",
#'   description = "string",
#'   source = list(
#'     type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'     location = "string",
#'     gitCloneDepth = 123,
#'     gitSubmodulesConfig = list(
#'       fetchSubmodules = TRUE|FALSE
#'     ),
#'     buildspec = "string",
#'     auth = list(
#'       type = "OAUTH",
#'       resource = "string"
#'     ),
#'     reportBuildStatus = TRUE|FALSE,
#'     buildStatusConfig = list(
#'       context = "string",
#'       targetUrl = "string"
#'     ),
#'     insecureSsl = TRUE|FALSE,
#'     sourceIdentifier = "string"
#'   ),
#'   secondarySources = list(
#'     list(
#'       type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
#'       location = "string",
#'       gitCloneDepth = 123,
#'       gitSubmodulesConfig = list(
#'         fetchSubmodules = TRUE|FALSE
#'       ),
#'       buildspec = "string",
#'       auth = list(
#'         type = "OAUTH",
#'         resource = "string"
#'       ),
#'       reportBuildStatus = TRUE|FALSE,
#'       buildStatusConfig = list(
#'         context = "string",
#'         targetUrl = "string"
#'       ),
#'       insecureSsl = TRUE|FALSE,
#'       sourceIdentifier = "string"
#'     )
#'   ),
#'   sourceVersion = "string",
#'   secondarySourceVersions = list(
#'     list(
#'       sourceIdentifier = "string",
#'       sourceVersion = "string"
#'     )
#'   ),
#'   artifacts = list(
#'     type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'     location = "string",
#'     path = "string",
#'     namespaceType = "NONE"|"BUILD_ID",
#'     name = "string",
#'     packaging = "NONE"|"ZIP",
#'     overrideArtifactName = TRUE|FALSE,
#'     encryptionDisabled = TRUE|FALSE,
#'     artifactIdentifier = "string"
#'   ),
#'   secondaryArtifacts = list(
#'     list(
#'       type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
#'       location = "string",
#'       path = "string",
#'       namespaceType = "NONE"|"BUILD_ID",
#'       name = "string",
#'       packaging = "NONE"|"ZIP",
#'       overrideArtifactName = TRUE|FALSE,
#'       encryptionDisabled = TRUE|FALSE,
#'       artifactIdentifier = "string"
#'     )
#'   ),
#'   cache = list(
#'     type = "NO_CACHE"|"S3"|"LOCAL",
#'     location = "string",
#'     modes = list(
#'       "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
#'     )
#'   ),
#'   environment = list(
#'     type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
#'     image = "string",
#'     computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
#'     environmentVariables = list(
#'       list(
#'         name = "string",
#'         value = "string",
#'         type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
#'       )
#'     ),
#'     privilegedMode = TRUE|FALSE,
#'     certificate = "string",
#'     registryCredential = list(
#'       credential = "string",
#'       credentialProvider = "SECRETS_MANAGER"
#'     ),
#'     imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
#'   ),
#'   serviceRole = "string",
#'   timeoutInMinutes = 123,
#'   queuedTimeoutInMinutes = 123,
#'   encryptionKey = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   vpcConfig = list(
#'     vpcId = "string",
#'     subnets = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   badgeEnabled = TRUE|FALSE,
#'   logsConfig = list(
#'     cloudWatchLogs = list(
#'       status = "ENABLED"|"DISABLED",
#'       groupName = "string",
#'       streamName = "string"
#'     ),
#'     s3Logs = list(
#'       status = "ENABLED"|"DISABLED",
#'       location = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   fileSystemLocations = list(
#'     list(
#'       type = "EFS",
#'       location = "string",
#'       mountPoint = "string",
#'       identifier = "string",
#'       mountOptions = "string"
#'     )
#'   ),
#'   buildBatchConfig = list(
#'     serviceRole = "string",
#'     combineArtifacts = TRUE|FALSE,
#'     restrictions = list(
#'       maximumBuildsAllowed = 123,
#'       computeTypesAllowed = list(
#'         "string"
#'       )
#'     ),
#'     timeoutInMins = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_update_project
codebuild_update_project <- function(name, description = NULL, source = NULL, secondarySources = NULL, sourceVersion = NULL, secondarySourceVersions = NULL, artifacts = NULL, secondaryArtifacts = NULL, cache = NULL, environment = NULL, serviceRole = NULL, timeoutInMinutes = NULL, queuedTimeoutInMinutes = NULL, encryptionKey = NULL, tags = NULL, vpcConfig = NULL, badgeEnabled = NULL, logsConfig = NULL, fileSystemLocations = NULL, buildBatchConfig = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_project_input(name = name, description = description, source = source, secondarySources = secondarySources, sourceVersion = sourceVersion, secondarySourceVersions = secondarySourceVersions, artifacts = artifacts, secondaryArtifacts = secondaryArtifacts, cache = cache, environment = environment, serviceRole = serviceRole, timeoutInMinutes = timeoutInMinutes, queuedTimeoutInMinutes = queuedTimeoutInMinutes, encryptionKey = encryptionKey, tags = tags, vpcConfig = vpcConfig, badgeEnabled = badgeEnabled, logsConfig = logsConfig, fileSystemLocations = fileSystemLocations, buildBatchConfig = buildBatchConfig)
  output <- .codebuild$update_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_project <- codebuild_update_project

#' Updates a report group
#'
#' @description
#' Updates a report group.
#'
#' @usage
#' codebuild_update_report_group(arn, exportConfig, tags)
#'
#' @param arn &#91;required&#93; The ARN of the report group to update.
#' @param exportConfig Used to specify an updated export type. Valid values are:
#' 
#' -   `S3`: The report results are exported to an S3 bucket.
#' 
#' -   `NO_EXPORT`: The report results are not exported.
#' @param tags An updated list of tag key and value pairs associated with this report
#' group.
#' 
#' These tags are available for use by AWS services that support AWS
#' CodeBuild report group tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   reportGroup = list(
#'     arn = "string",
#'     name = "string",
#'     type = "TEST"|"CODE_COVERAGE",
#'     exportConfig = list(
#'       exportConfigType = "S3"|"NO_EXPORT",
#'       s3Destination = list(
#'         bucket = "string",
#'         path = "string",
#'         packaging = "ZIP"|"NONE",
#'         encryptionKey = "string",
#'         encryptionDisabled = TRUE|FALSE
#'       )
#'     ),
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastModified = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     status = "ACTIVE"|"DELETING"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_report_group(
#'   arn = "string",
#'   exportConfig = list(
#'     exportConfigType = "S3"|"NO_EXPORT",
#'     s3Destination = list(
#'       bucket = "string",
#'       path = "string",
#'       packaging = "ZIP"|"NONE",
#'       encryptionKey = "string",
#'       encryptionDisabled = TRUE|FALSE
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_update_report_group
codebuild_update_report_group <- function(arn, exportConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "UpdateReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_report_group_input(arn = arn, exportConfig = exportConfig, tags = tags)
  output <- .codebuild$update_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_report_group <- codebuild_update_report_group

#' Updates the webhook associated with an AWS CodeBuild build project
#'
#' @description
#' Updates the webhook associated with an AWS CodeBuild build project.
#' 
#' If you use Bitbucket for your repository, `rotateSecret` is ignored.
#'
#' @usage
#' codebuild_update_webhook(projectName, branchFilter, rotateSecret,
#'   filterGroups, buildType)
#'
#' @param projectName &#91;required&#93; The name of the AWS CodeBuild project.
#' @param branchFilter A regular expression used to determine which repository branches are
#' built when a webhook is triggered. If the name of a branch matches the
#' regular expression, then it is built. If `branchFilter` is empty, then
#' all branches are built.
#' 
#' It is recommended that you use `filterGroups` instead of `branchFilter`.
#' @param rotateSecret A boolean value that specifies whether the associated GitHub
#' repository's secret token should be updated. If you use Bitbucket for
#' your repository, `rotateSecret` is ignored.
#' @param filterGroups An array of arrays of `WebhookFilter` objects used to determine if a
#' webhook event can trigger a build. A filter group must contain at least
#' one `EVENT` `WebhookFilter`.
#' @param buildType Specifies the type of build this webhook will trigger.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   webhook = list(
#'     url = "string",
#'     payloadUrl = "string",
#'     secret = "string",
#'     branchFilter = "string",
#'     filterGroups = list(
#'       list(
#'         list(
#'           type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'           pattern = "string",
#'           excludeMatchedPattern = TRUE|FALSE
#'         )
#'       )
#'     ),
#'     buildType = "BUILD"|"BUILD_BATCH",
#'     lastModifiedSecret = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_webhook(
#'   projectName = "string",
#'   branchFilter = "string",
#'   rotateSecret = TRUE|FALSE,
#'   filterGroups = list(
#'     list(
#'       list(
#'         type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
#'         pattern = "string",
#'         excludeMatchedPattern = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   buildType = "BUILD"|"BUILD_BATCH"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codebuild_update_webhook
codebuild_update_webhook <- function(projectName, branchFilter = NULL, rotateSecret = NULL, filterGroups = NULL, buildType = NULL) {
  op <- new_operation(
    name = "UpdateWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_webhook_input(projectName = projectName, branchFilter = branchFilter, rotateSecret = rotateSecret, filterGroups = filterGroups, buildType = buildType)
  output <- .codebuild$update_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_webhook <- codebuild_update_webhook
