% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_recommendations}
\alias{rds_describe_db_recommendations}
\title{Describes the recommendations to resolve the issues for your DB
instances, DB clusters, and DB parameter groups}
\usage{
rds_describe_db_recommendations(
  LastUpdatedAfter = NULL,
  LastUpdatedBefore = NULL,
  Locale = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{LastUpdatedAfter}{A filter to include only the recommendations that were updated after
this specified time.}

\item{LastUpdatedBefore}{A filter to include only the recommendations that were updated before
this specified time.}

\item{Locale}{The language that you choose to return the list of recommendations.

Valid values:
\itemize{
\item \code{en}
\item \code{en_UK}
\item \code{de}
\item \code{es}
\item \code{fr}
\item \code{id}
\item \code{it}
\item \code{ja}
\item \code{ko}
\item \code{pt_BR}
\item \code{zh_TW}
\item \code{zh_CN}
}}

\item{Filters}{A filter that specifies one or more recommendations to describe.

Supported Filters:
\itemize{
\item \code{recommendation-id} - Accepts a list of recommendation identifiers.
The results list only includes the recommendations whose identifier
is one of the specified filter values.
\item \code{status} - Accepts a list of recommendation statuses.

Valid values:
\itemize{
\item \code{active} - The recommendations which are ready for you to apply.
\item \code{pending} - The applied or scheduled recommendations which are
in progress.
\item \code{resolved} - The recommendations which are completed.
\item \code{dismissed} - The recommendations that you dismissed.
}

The results list only includes the recommendations whose status is
one of the specified filter values.
\item \code{severity} - Accepts a list of recommendation severities. The
results list only includes the recommendations whose severity is one
of the specified filter values.

Valid values:
\itemize{
\item \code{high}
\item \code{medium}
\item \code{low}
\item \code{informational}
}
\item \code{type-id} - Accepts a list of recommendation type identifiers. The
results list only includes the recommendations whose type is one of
the specified filter values.
\item \code{dbi-resource-id} - Accepts a list of database resource identifiers.
The results list only includes the recommendations that generated
for the specified databases.
\item \code{cluster-resource-id} - Accepts a list of cluster resource
identifiers. The results list only includes the recommendations that
generated for the specified clusters.
\item \code{pg-arn} - Accepts a list of parameter group ARNs. The results list
only includes the recommendations that generated for the specified
parameter groups.
\item \code{cluster-pg-arn} - Accepts a list of cluster parameter group ARNs.
The results list only includes the recommendations that generated
for the specified cluster parameter groups.
}}

\item{MaxRecords}{The maximum number of recommendations to include in the response. If
more records exist than the specified \code{MaxRecords} value, a pagination
token called a marker is included in the response so that you can
retrieve the remaining results.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_recommendations]{describe_db_recommendations}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_recommendations/} for full documentation.
}
\keyword{internal}
