% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_put_resource_policy}
\alias{dynamodb_put_resource_policy}
\title{Attaches a resource-based policy document to the resource, which can be
a table or stream}
\usage{
dynamodb_put_resource_policy(
  ResourceArn,
  Policy,
  ExpectedRevisionId = NULL,
  ConfirmRemoveSelfResourceAccess = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the DynamoDB resource to which the
policy will be attached. The resources you can specify include tables
and streams.

You can control index permissions using the base table's policy. To
specify the same permission level for your table and its indexes, you
can provide both the table and index Amazon Resource Name (ARN)s in the
\code{Resource} field of a given \code{Statement} in your policy document.
Alternatively, to specify different permissions for your table, indexes,
or both, you can define multiple \code{Statement} fields in your policy
document.}

\item{Policy}{[required] An Amazon Web Services resource-based policy document in JSON format.

The maximum size supported for a resource-based policy document is 20
KB. DynamoDB counts whitespaces when calculating the size of a policy
against this limit. For a full list of all considerations that you
should keep in mind while attaching a resource-based policy, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html}{Resource-based policy considerations}.}

\item{ExpectedRevisionId}{A string value that you can use to conditionally update your policy. You
can provide the revision ID of your existing policy to make mutating
requests against that policy. When you provide an expected revision ID,
if the revision ID of the existing policy on the resource doesn't match
or if there's no policy attached to the resource, your request will be
rejected with a \code{PolicyNotFoundException}.

To conditionally put a policy when no policy exists for the resource,
specify \code{NO_POLICY} for the revision ID.}

\item{ConfirmRemoveSelfResourceAccess}{Set this parameter to \code{true} to confirm that you want to remove your
permissions to change the policy of this resource in the future.}
}
\description{
Attaches a resource-based policy document to the resource, which can be a table or stream. When you attach a resource-based policy using this API, the policy application is \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.html}{\emph{eventually consistent}} .

See \url{https://www.paws-r-sdk.com/docs/dynamodb_put_resource_policy/} for full documentation.
}
\keyword{internal}
