% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_event_subscriptions}
\alias{redshift_describe_event_subscriptions}
\title{Lists descriptions of all the Amazon Redshift event notification
subscriptions for a customer account}
\usage{
redshift_describe_event_subscriptions(
  SubscriptionName = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  TagKeys = NULL,
  TagValues = NULL
)
}
\arguments{
\item{SubscriptionName}{The name of the Amazon Redshift event notification subscription to be
described.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeEventSubscriptions
request exceed the value specified in \code{MaxRecords}, Amazon Web Services
returns a value in the \code{Marker} field of the response. You can retrieve
the next set of response records by providing the returned marker value
in the \code{Marker} parameter and retrying the request.}

\item{TagKeys}{A tag key or keys for which you want to return all matching event
notification subscriptions that are associated with the specified key or
keys. For example, suppose that you have subscriptions that are tagged
with keys called \code{owner} and \code{environment}. If you specify both of these
tag keys in the request, Amazon Redshift returns a response with the
subscriptions that have either or both of these tag keys associated with
them.}

\item{TagValues}{A tag value or values for which you want to return all matching event
notification subscriptions that are associated with the specified tag
value or values. For example, suppose that you have subscriptions that
are tagged with values called \code{admin} and \code{test}. If you specify both of
these tag values in the request, Amazon Redshift returns a response with
the subscriptions that have either or both of these tag values
associated with them.}
}
\description{
Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.

See \url{https://paws-r.github.io/docs/redshift/describe_event_subscriptions.html} for full documentation.
}
\keyword{internal}
