% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_transact_write_items}
\alias{dynamodb_transact_write_items}
\title{TransactWriteItems is a synchronous write operation that groups up to 25
action requests}
\usage{
dynamodb_transact_write_items(
  TransactItems,
  ReturnConsumedCapacity = NULL,
  ReturnItemCollectionMetrics = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{TransactItems}{[required] An ordered array of up to 25 \code{TransactWriteItem} objects, each of which
contains a \code{ConditionCheck}, \code{Put}, \code{Update}, or \code{Delete} object. These
can operate on items in different tables, but the tables must reside in
the same Amazon Web Services account and Region, and no two of them can
operate on the same item.}

\item{ReturnConsumedCapacity}{}

\item{ReturnItemCollectionMetrics}{Determines whether item collection metrics are returned. If set to
\code{SIZE}, the response includes statistics about item collections (if
any), that were modified during the operation and are returned in the
response. If set to \code{NONE} (the default), no statistics are returned.}

\item{ClientRequestToken}{Providing a \code{ClientRequestToken} makes the call to
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} idempotent,
meaning that multiple identical calls have the same effect as one single
call.

Although multiple identical calls using the same client request token
produce the same result on the server (no side effects), the responses
to the calls might not be the same. If the \verb{ReturnConsumedCapacity>}
parameter is set, then the initial
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} call returns the
amount of write capacity units consumed in making the changes.
Subsequent \code{\link[=dynamodb_transact_write_items]{transact_write_items}} calls
with the same client token return the number of read capacity units
consumed in reading the item.

A client request token is valid for 10 minutes after the first request
that uses it is completed. After 10 minutes, any request with the same
client token is treated as a new request. Do not resubmit the same
request with the same client token for more than 10 minutes, or the
result might not be idempotent.

If you submit a request with the same client token but a change in other
parameters within the 10-minute idempotency window, DynamoDB returns an
\code{IdempotentParameterMismatch} exception.}
}
\description{
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} is a synchronous write operation that groups up to 25 action requests. These actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and no two actions can target the same item. For example, you cannot both \code{ConditionCheck} and \code{Update} the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.

See \url{https://paws-r.github.io/docs/dynamodb/transact_write_items.html} for full documentation.
}
\keyword{internal}
