# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon QLDB Session
#'
#' @description
#' The transactional data APIs for Amazon QLDB
#' 
#' Instead of interacting directly with this API, we recommend using the
#' QLDB driver or the QLDB shell to execute data transactions on a ledger.
#' 
#' -   If you are working with an AWS SDK, use the QLDB driver. The driver
#'     provides a high-level abstraction layer above this *QLDB Session*
#'     data plane and manages [`send_command`][qldbsession_send_command]
#'     API calls for you. For information and a list of supported
#'     programming languages, see [Getting started with the
#'     driver](https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-driver.html)
#'     in the *Amazon QLDB Developer Guide*.
#' 
#' -   If you are working with the AWS Command Line Interface (AWS CLI),
#'     use the QLDB shell. The shell is a command line interface that uses
#'     the QLDB driver to interact with a ledger. For information, see
#'     [Accessing Amazon QLDB using the QLDB
#'     shell](https://docs.aws.amazon.com/qldb/latest/developerguide/data-shell.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- qldbsession(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- qldbsession()
#' svc$send_command(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=qldbsession_send_command]{send_command} \tab Sends a command to an Amazon QLDB ledger
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname qldbsession
#' @export
qldbsession <- function(config = list()) {
  svc <- .qldbsession$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.qldbsession <- list()

.qldbsession$operations <- list()

.qldbsession$metadata <- list(
  service_name = "qldbsession",
  endpoints = list("*" = list(endpoint = "session.qldb.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "session.qldb.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "session.qldb.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "session.qldb.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "QLDB Session",
  api_version = "2019-07-11",
  signing_name = "qldb",
  json_version = "1.0",
  target_prefix = "QLDBSession"
)

.qldbsession$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.qldbsession$metadata, handlers, config)
}
