% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_snapshots}
\alias{rds_describe_db_cluster_snapshots}
\title{Returns information about DB cluster snapshots}
\usage{
rds_describe_db_cluster_snapshots(DBClusterIdentifier,
  DBClusterSnapshotIdentifier, SnapshotType, Filters, MaxRecords, Marker,
  IncludeShared, IncludePublic)
}
\arguments{
\item{DBClusterIdentifier}{The ID of the DB cluster to retrieve the list of DB cluster snapshots
for. This parameter can't be used in conjunction with the
\code{DBClusterSnapshotIdentifier} parameter. This parameter is not
case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBCluster.
}}

\item{DBClusterSnapshotIdentifier}{A specific DB cluster snapshot identifier to describe. This parameter
can't be used in conjunction with the \code{DBClusterIdentifier} parameter.
This value is stored as a lowercase string.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing
DBClusterSnapshot.
\item If this identifier is for an automated snapshot, the \code{SnapshotType}
parameter must also be specified.
}}

\item{SnapshotType}{The type of DB cluster snapshots to be returned. You can specify one of
the following values:
\itemize{
\item \code{automated} - Return all DB cluster snapshots that have been
automatically taken by Amazon RDS for my AWS account.
\item \code{manual} - Return all DB cluster snapshots that have been taken by
my AWS account.
\item \code{shared} - Return all manual DB cluster snapshots that have been
shared to my AWS account.
\item \code{public} - Return all DB cluster snapshots that have been marked as
public.
}

If you don't specify a \code{SnapshotType} value, then both automated and
manual DB cluster snapshots are returned. You can include shared DB
cluster snapshots with these results by enabling the \code{IncludeShared}
parameter. You can include public DB cluster snapshots with these
results by enabling the \code{IncludePublic} parameter.

The \code{IncludeShared} and \code{IncludePublic} parameters don't apply for
\code{SnapshotType} values of \code{manual} or \code{automated}. The \code{IncludePublic}
parameter doesn't apply when \code{SnapshotType} is set to \code{shared}. The
\code{IncludeShared} parameter doesn't apply when \code{SnapshotType} is set to
\code{public}.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBClusterSnapshots} request. If this parameter is specified,
the response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}

\item{IncludeShared}{A value that indicates whether to include shared manual DB cluster
snapshots from other AWS accounts that this AWS account has been given
permission to copy or restore. By default, these snapshots are not
included.

You can give an AWS account permission to restore a manual DB cluster
snapshot from another AWS account by the
\code{ModifyDBClusterSnapshotAttribute} API action.}

\item{IncludePublic}{A value that indicates whether to include manual DB cluster snapshots
that are public and can be copied or restored by any AWS account. By
default, the public snapshots are not included.

You can share a manual DB cluster snapshot as public by using the
ModifyDBClusterSnapshotAttribute API action.}
}
\description{
Returns information about DB cluster snapshots. This API action supports
pagination.
}
\details{
For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_snapshots(
  DBClusterIdentifier = "string",
  DBClusterSnapshotIdentifier = "string",
  SnapshotType = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string",
  IncludeShared = TRUE|FALSE,
  IncludePublic = TRUE|FALSE
)
}
}

\keyword{internal}
