% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_instance}
\alias{neptune_create_db_instance}
\title{Creates a new DB instance}
\usage{
neptune_create_db_instance(DBName, DBInstanceIdentifier,
  AllocatedStorage, DBInstanceClass, Engine, MasterUsername,
  MasterUserPassword, DBSecurityGroups, VpcSecurityGroupIds,
  AvailabilityZone, DBSubnetGroupName, PreferredMaintenanceWindow,
  DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
  Port, MultiAZ, EngineVersion, AutoMinorVersionUpgrade, LicenseModel,
  Iops, OptionGroupName, CharacterSetName, PubliclyAccessible, Tags,
  DBClusterIdentifier, StorageType, TdeCredentialArn,
  TdeCredentialPassword, StorageEncrypted, KmsKeyId, Domain,
  CopyTagsToSnapshot, MonitoringInterval, MonitoringRoleArn,
  DomainIAMRoleName, PromotionTier, Timezone,
  EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
  PerformanceInsightsKMSKeyId, EnableCloudwatchLogsExports)
}
\arguments{
\item{DBName}{Not supported.}

\item{DBInstanceIdentifier}{[required] The DB instance identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{AllocatedStorage}{The amount of storage (in gibibytes) to allocate for the DB instance.

Type: Integer

Not applicable. Neptune cluster volumes automatically grow as the amount
of data in your database increases, though you are only charged for the
space that you use in a Neptune cluster volume.}

\item{DBInstanceClass}{[required] The compute and memory capacity of the DB instance, for example,
\code{db.m4.large}. Not all DB instance classes are available in all AWS
Regions.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

Valid Values: \code{neptune}}

\item{MasterUsername}{The name for the master user. Not used.}

\item{MasterUserPassword}{The password for the master user. The password can include any printable
ASCII character except "/", """, or "@".

Not used.}

\item{DBSecurityGroups}{A list of DB security groups to associate with this DB instance.

Default: The default DB security group for the database engine.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Not applicable. The associated list of EC2 VPC security groups is
managed by the DB cluster. For more information, see CreateDBCluster.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{AvailabilityZone}{The EC2 Availability Zone that the DB instance is created in

Default: A random, system-chosen Availability Zone in the endpoint's
AWS Region.

Example: \code{us-east-1d}

Constraint: The AvailabilityZone parameter can't be specified if the
MultiAZ parameter is set to \code{true}. The specified Availability Zone must
be in the same AWS Region as the current endpoint.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB instance.

If there is no DB subnet group, then it is a non-VPC DB instance.}

\item{PreferredMaintenanceWindow}{The time range each week during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week.

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.
If this argument is omitted, the default DBParameterGroup for the
specified engine is used.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained.

Not applicable. The retention period for automated backups is managed by
the DB cluster. For more information, see CreateDBCluster.

Default: 1

Constraints:
\itemize{
\item Must be a value from 0 to 35
\item Cannot be set to 0 if the DB instance is a source to Read Replicas
}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created.

Not applicable. The daily time range for creating automated backups is
managed by the DB cluster. For more information, see CreateDBCluster.}

\item{Port}{The port number on which the database accepts connections.

Not applicable. The port is managed by the DB cluster. For more
information, see CreateDBCluster.

Default: \code{8182}

Type: Integer}

\item{MultiAZ}{Specifies if the DB instance is a Multi-AZ deployment. You can't set
the AvailabilityZone parameter if the MultiAZ parameter is set to true.}

\item{EngineVersion}{The version number of the database engine to use.}

\item{AutoMinorVersionUpgrade}{Indicates that minor engine upgrades are applied automatically to the DB
instance during the maintenance window.

Default: \code{true}}

\item{LicenseModel}{License model information for this DB instance.

Valid values: \code{license-included} \| \code{bring-your-own-license} \|
\code{general-public-license}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.}

\item{OptionGroupName}{Indicates that the DB instance should be associated with the specified
option group.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group
can't be removed from a DB instance once it is associated with a DB
instance}

\item{CharacterSetName}{Indicates that the DB instance should be associated with the specified
CharacterSet.

Not applicable. The character set is managed by the DB cluster. For more
information, see CreateDBCluster.}

\item{PubliclyAccessible}{This flag should no longer be used.}

\item{Tags}{The tags to assign to the new instance.}

\item{DBClusterIdentifier}{The identifier of the DB cluster that the instance will belong to.

For information on creating a DB cluster, see CreateDBCluster.

Type: String}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Not applicable. Storage is managed by the DB Cluster.}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{StorageEncrypted}{Specifies whether the DB instance is encrypted.

Not applicable. The encryption for DB instances is managed by the DB
cluster. For more information, see CreateDBCluster.

Default: false}

\item{KmsKeyId}{The AWS KMS key identifier for an encrypted DB instance.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB instance with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
instance, then you can use the KMS key alias instead of the ARN for the
KM encryption key.

Not applicable. The KMS key identifier is managed by the DB cluster. For
more information, see CreateDBCluster.

If the \code{StorageEncrypted} parameter is true, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon Neptune will use your
default encryption key. AWS KMS creates the default encryption key for
your AWS account. Your AWS account has a different default encryption
key for each AWS Region.}

\item{Domain}{Specify the Active Directory Domain to create the instance in.}

\item{CopyTagsToSnapshot}{True to copy all tags from the DB instance to snapshots of the DB
instance, and otherwise false. The default is false.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0. The default is 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: \code{0, 1, 5, 10, 15, 30, 60}}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits Neptune to send enhanced
monitoring metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}.

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{PromotionTier}{A value that specifies the order in which an Read Replica is promoted to
the primary instance after a failure of the existing primary instance.

Default: 1

Valid Values: 0 - 15}

\item{Timezone}{The time zone of the DB instance.}

\item{EnableIAMDatabaseAuthentication}{True to enable AWS Identity and Access Management (IAM) authentication
for Neptune.

Default: \code{false}}

\item{EnablePerformanceInsights}{True to enable Performance Insights for the DB instance, and otherwise
false.}

\item{PerformanceInsightsKMSKeyId}{The AWS KMS key identifier for encryption of Performance Insights data.
The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
the KMS key alias for the KMS encryption key.}

\item{EnableCloudwatchLogsExports}{The list of log types that need to be enabled for exporting to
CloudWatch Logs.}
}
\description{
Creates a new DB instance.
}
\section{Request syntax}{
\preformatted{svc$create_db_instance(
  DBName = "string",
  DBInstanceIdentifier = "string",
  AllocatedStorage = 123,
  DBInstanceClass = "string",
  Engine = "string",
  MasterUsername = "string",
  MasterUserPassword = "string",
  DBSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  AvailabilityZone = "string",
  DBSubnetGroupName = "string",
  PreferredMaintenanceWindow = "string",
  DBParameterGroupName = "string",
  BackupRetentionPeriod = 123,
  PreferredBackupWindow = "string",
  Port = 123,
  MultiAZ = TRUE|FALSE,
  EngineVersion = "string",
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  Iops = 123,
  OptionGroupName = "string",
  CharacterSetName = "string",
  PubliclyAccessible = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  DBClusterIdentifier = "string",
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  StorageEncrypted = TRUE|FALSE,
  KmsKeyId = "string",
  Domain = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  MonitoringInterval = 123,
  MonitoringRoleArn = "string",
  DomainIAMRoleName = "string",
  PromotionTier = 123,
  Timezone = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnablePerformanceInsights = TRUE|FALSE,
  PerformanceInsightsKMSKeyId = "string",
  EnableCloudwatchLogsExports = list(
    "string"
  )
)
}
}

\keyword{internal}
