% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_batch_get_item}
\alias{dynamodb_batch_get_item}
\title{The BatchGetItem operation returns the attributes of one or more items
from one or more tables}
\usage{
dynamodb_batch_get_item(RequestItems, ReturnConsumedCapacity)
}
\arguments{
\item{RequestItems}{[required] A map of one or more table names and, for each table, a map that
describes one or more items to retrieve from that table. Each table name
can be used only once per \code{BatchGetItem} request.

Each element in the map of items to retrieve consists of the following:
\itemize{
\item \code{ConsistentRead} - If \code{true}, a strongly consistent read is used; if
\code{false} (the default), an eventually consistent read is used.
\item \code{ExpressionAttributeNames} - One or more substitution tokens for
attribute names in the \code{ProjectionExpression} parameter. The
following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB
reserved word.
\item To create a placeholder for repeating occurrences of an
attribute name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{\#} character in an expression to dereference an
attribute name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it
cannot be used directly in an expression. (For the complete list of
reserved words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \code{\{"#P":"Percentile"\}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \code{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information about expression attribute names, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html}{Accessing Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.
\item \code{Keys} - An array of primary key attribute values that define
specific items in the table. For each primary key, you must provide
\emph{all} of the key attributes. For example, with a simple primary key,
you only need to provide the partition key value. For a composite
key, you must provide \emph{both} the partition key value and the sort
key value.
\item \code{ProjectionExpression} - A string that identifies one or more
attributes to retrieve from the table. These attributes can include
scalars, sets, or elements of a JSON document. The attributes in the
expression must be separated by commas.

If no attribute names are specified, then all attributes are
returned. If any of the requested attributes are not found, they do
not appear in the result.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html}{Accessing Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.
\item \code{AttributesToGet} - This is a legacy parameter. Use
\code{ProjectionExpression} instead. For more information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html}{AttributesToGet}
in the \emph{Amazon DynamoDB Developer Guide}.
}}

\item{ReturnConsumedCapacity}{}
}
\description{
The \code{BatchGetItem} operation returns the attributes of one or more items
from one or more tables. You identify requested items by primary key.
}
\details{
A single operation can retrieve up to 16 MB of data, which can contain
as many as 100 items. \code{BatchGetItem} returns a partial result if the
response size limit is exceeded, the table's provisioned throughput is
exceeded, or an internal processing failure occurs. If a partial result
is returned, the operation returns a value for \code{UnprocessedKeys}. You
can use this value to retry the operation starting with the next item to
get.

If you request more than 100 items, \code{BatchGetItem} returns a
\code{ValidationException} with the message "Too many items requested for
the BatchGetItem call."

For example, if you ask to retrieve 100 items, but each individual item
is 300 KB in size, the system returns 52 items (so as not to exceed the
16 MB limit). It also returns an appropriate \code{UnprocessedKeys} value so
you can get the next page of results. If desired, your application can
include its own logic to assemble the pages of results into one dataset.

If \emph{none} of the items can be processed due to insufficient provisioned
throughput on all of the tables in the request, then \code{BatchGetItem}
returns a \code{ProvisionedThroughputExceededException}. If \emph{at least one} of
the items is successfully processed, then \code{BatchGetItem} completes
successfully, while returning the keys of the unread items in
\code{UnprocessedKeys}.

If DynamoDB returns any unprocessed items, you should retry the batch
operation on those items. However, \emph{we strongly recommend that you use
an exponential backoff algorithm}. If you retry the batch operation
immediately, the underlying read or write requests can still fail due to
throttling on the individual tables. If you delay the batch operation
using exponential backoff, the individual requests in the batch are much
more likely to succeed.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations}{Batch Operations and Error Handling}
in the \emph{Amazon DynamoDB Developer Guide}.

By default, \code{BatchGetItem} performs eventually consistent reads on every
table in the request. If you want strongly consistent reads instead, you
can set \code{ConsistentRead} to \code{true} for any or all tables.

In order to minimize response latency, \code{BatchGetItem} retrieves items in
parallel.

When designing your application, keep in mind that DynamoDB does not
return items in any particular order. To help parse the response by
item, include the primary key values for the items in your request in
the \code{ProjectionExpression} parameter.

If a requested item does not exist, it is not returned in the result.
Requests for nonexistent items consume the minimum read capacity units
according to the type of read. For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations}{Working with Tables}
in the \emph{Amazon DynamoDB Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$batch_get_item(
  RequestItems = list(
    list(
      Keys = list(
        list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        )
      ),
      AttributesToGet = list(
        "string"
      ),
      ConsistentRead = TRUE|FALSE,
      ProjectionExpression = "string",
      ExpressionAttributeNames = list(
        "string"
      )
    )
  ),
  ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE"
)
}
}

\examples{
# This example reads multiple items from the Music table using a batch of
# three GetItem requests.  Only the AlbumTitle attribute is returned.
\donttest{svc$batch_get_item(
  RequestItems = list(
    Music = list(
      Keys = list(
        list(
          Artist = list(
            S = "No One You Know"
          ),
          SongTitle = list(
            S = "Call Me Today"
          )
        ),
        list(
          Artist = list(
            S = "Acme Band"
          ),
          SongTitle = list(
            S = "Happy Day"
          )
        ),
        list(
          Artist = list(
            S = "No One You Know"
          ),
          SongTitle = list(
            S = "Scared of My Shadow"
          )
        )
      ),
      ProjectionExpression = "AlbumTitle"
    )
  )
)}

}
\keyword{internal}
