% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_option_groups}
\alias{rds_describe_option_groups}
\title{Describes the available option groups}
\usage{
rds_describe_option_groups(OptionGroupName, Filters, Marker, MaxRecords,
  EngineName, MajorEngineVersion)
}
\arguments{
\item{OptionGroupName}{The name of the option group to describe. Can't be supplied together
with EngineName or MajorEngineVersion.}

\item{Filters}{This parameter isn't currently supported.}

\item{Marker}{An optional pagination token provided by a previous DescribeOptionGroups
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{EngineName}{Filters the list of option groups to only include groups associated with
a specific database engine.}

\item{MajorEngineVersion}{Filters the list of option groups to only include groups associated with
a specific database engine version. If specified, then EngineName must
also be specified.}
}
\value{
A list with the following syntax:\preformatted{list(
  OptionGroupsList = list(
    list(
      OptionGroupName = "string",
      OptionGroupDescription = "string",
      EngineName = "string",
      MajorEngineVersion = "string",
      Options = list(
        list(
          OptionName = "string",
          OptionDescription = "string",
          Persistent = TRUE|FALSE,
          Permanent = TRUE|FALSE,
          Port = 123,
          OptionVersion = "string",
          OptionSettings = list(
            list(
              Name = "string",
              Value = "string",
              DefaultValue = "string",
              Description = "string",
              ApplyType = "string",
              DataType = "string",
              AllowedValues = "string",
              IsModifiable = TRUE|FALSE,
              IsCollection = TRUE|FALSE
            )
          ),
          DBSecurityGroupMemberships = list(
            list(
              DBSecurityGroupName = "string",
              Status = "string"
            )
          ),
          VpcSecurityGroupMemberships = list(
            list(
              VpcSecurityGroupId = "string",
              Status = "string"
            )
          )
        )
      ),
      AllowsVpcAndNonVpcInstanceMemberships = TRUE|FALSE,
      VpcId = "string",
      OptionGroupArn = "string"
    )
  ),
  Marker = "string"
)
}
}
\description{
Describes the available option groups.
}
\section{Request syntax}{
\preformatted{svc$describe_option_groups(
  OptionGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  Marker = "string",
  MaxRecords = 123,
  EngineName = "string",
  MajorEngineVersion = "string"
)
}
}

\keyword{internal}
