% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_proxy}
\alias{rds_delete_db_proxy}
\title{Deletes an existing proxy}
\usage{
rds_delete_db_proxy(DBProxyName)
}
\arguments{
\item{DBProxyName}{[required] The name of the DB proxy to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBProxy = list(
    DBProxyName = "string",
    DBProxyArn = "string",
    Status = "available"|"modifying"|"incompatible-network"|"insufficient-resource-limits"|"creating"|"deleting"|"suspended"|"suspending"|"reactivating",
    EngineFamily = "string",
    VpcSecurityGroupIds = list(
      "string"
    ),
    VpcSubnetIds = list(
      "string"
    ),
    Auth = list(
      list(
        Description = "string",
        UserName = "string",
        AuthScheme = "SECRETS",
        SecretArn = "string",
        IAMAuth = "DISABLED"|"REQUIRED"
      )
    ),
    RoleArn = "string",
    Endpoint = "string",
    RequireTLS = TRUE|FALSE,
    IdleClientTimeout = 123,
    DebugLogging = TRUE|FALSE,
    CreatedDate = as.POSIXct(
      "2015-01-01"
    ),
    UpdatedDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Deletes an existing proxy.
}
\section{Request syntax}{
\preformatted{svc$delete_db_proxy(
  DBProxyName = "string"
)
}
}

\keyword{internal}
