% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_distribution}
\alias{lightsail_update_distribution}
\title{Updates an existing Amazon Lightsail content delivery network (CDN)
distribution}
\usage{
lightsail_update_distribution(
  distributionName,
  origin = NULL,
  defaultCacheBehavior = NULL,
  cacheBehaviorSettings = NULL,
  cacheBehaviors = NULL,
  isEnabled = NULL,
  viewerMinimumTlsProtocolVersion = NULL,
  certificateName = NULL,
  useDefaultCertificate = NULL
)
}
\arguments{
\item{distributionName}{[required] The name of the distribution to update.

Use the \code{\link[=lightsail_get_distributions]{get_distributions}} action to get
a list of distribution names that you can specify.}

\item{origin}{An object that describes the origin resource for the distribution, such
as a Lightsail instance, bucket, or load balancer.

The distribution pulls, caches, and serves content from the origin.}

\item{defaultCacheBehavior}{An object that describes the default cache behavior for the
distribution.}

\item{cacheBehaviorSettings}{An object that describes the cache behavior settings for the
distribution.

The \code{cacheBehaviorSettings} specified in your
\code{UpdateDistributionRequest} will replace your distribution's existing
settings.}

\item{cacheBehaviors}{An array of objects that describe the per-path cache behavior for the
distribution.}

\item{isEnabled}{Indicates whether to enable the distribution.}

\item{viewerMinimumTlsProtocolVersion}{Use this parameter to update the minimum TLS protocol version for the
SSL/TLS certificate that's attached to the distribution.}

\item{certificateName}{The name of the SSL/TLS certificate that you want to attach to the
distribution.

Only certificates with a status of \code{ISSUED} can be attached to a
distribution.

Use the \code{\link[=lightsail_get_certificates]{get_certificates}} action to get a
list of certificate names that you can specify.}

\item{useDefaultCertificate}{Indicates whether the default SSL/TLS certificate is attached to the
distribution. The default value is \code{true}. When \code{true}, the distribution
uses the default domain name such as \code{d111111abcdef8.cloudfront.net}.

Set this value to \code{false} to attach a new certificate to the
distribution.}
}
\description{
Updates an existing Amazon Lightsail content delivery network (CDN) distribution.

See \url{https://www.paws-r-sdk.com/docs/lightsail_update_distribution/} for full documentation.
}
\keyword{internal}
