% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_addon}
\alias{eks_update_addon}
\title{Updates an Amazon EKS add-on}
\usage{
eks_update_addon(
  clusterName,
  addonName,
  addonVersion = NULL,
  serviceAccountRoleArn = NULL,
  resolveConflicts = NULL,
  clientRequestToken = NULL,
  configurationValues = NULL,
  podIdentityAssociations = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of your cluster.}

\item{addonName}{[required] The name of the add-on. The name must match one of the names returned by
\href{https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html}{\code{list_addons}}
.}

\item{addonVersion}{The version of the add-on. The version must match one of the versions
returned by
\href{https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html}{\code{describe_addon_versions}}
.}

\item{serviceAccountRoleArn}{The Amazon Resource Name (ARN) of an existing IAM role to bind to the
add-on's service account. The role must be assigned the IAM permissions
required by the add-on. If you don't specify an existing IAM role, then
the add-on uses the permissions assigned to the node IAM role. For more
information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html}{Amazon EKS node IAM role}
in the \emph{Amazon EKS User Guide}.

To specify an existing IAM role, you must have an IAM OpenID Connect
(OIDC) provider created for your cluster. For more information, see
\href{https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html}{Enabling IAM roles for service accounts on your cluster}
in the \emph{Amazon EKS User Guide}.}

\item{resolveConflicts}{How to resolve field value conflicts for an Amazon EKS add-on if you've
changed a value from the Amazon EKS default value. Conflicts are handled
based on the option you choose:
\itemize{
\item \strong{None} – Amazon EKS doesn't change the value. The update might
fail.
\item \strong{Overwrite} – Amazon EKS overwrites the changed value back to the
Amazon EKS default value.
\item \strong{Preserve} – Amazon EKS preserves the value. If you choose this
option, we recommend that you test any field and value changes on a
non-production cluster before updating the add-on on your production
cluster.
}}

\item{clientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{configurationValues}{The set of configuration values for the add-on that's created. The
values that you provide are validated against the schema returned by
\code{\link[=eks_describe_addon_configuration]{describe_addon_configuration}}.}

\item{podIdentityAssociations}{An array of Pod Identity Assocations to be updated. Each EKS Pod
Identity association maps a Kubernetes service account to an IAM Role.
If this value is left blank, no change. If an empty array is provided,
existing Pod Identity Assocations owned by the Addon are deleted.

For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html}{Attach an IAM Role to an Amazon EKS add-on using Pod Identity}
in the EKS User Guide.}
}
\description{
Updates an Amazon EKS add-on.

See \url{https://www.paws-r-sdk.com/docs/eks_update_addon/} for full documentation.
}
\keyword{internal}
