% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_create_pod_identity_association}
\alias{eks_create_pod_identity_association}
\title{Creates an EKS Pod Identity association between a service account in an
Amazon EKS cluster and an IAM role with EKS Pod Identity}
\usage{
eks_create_pod_identity_association(
  clusterName,
  namespace,
  serviceAccount,
  roleArn,
  clientRequestToken = NULL,
  tags = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to create the association in.}

\item{namespace}{[required] The name of the Kubernetes namespace inside the cluster to create the
association in. The service account and the pods that use the service
account must be in this namespace.}

\item{serviceAccount}{[required] The name of the Kubernetes service account inside the cluster to
associate the IAM credentials with.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to associate with the
service account. The EKS Pod Identity agent manages credentials to
assume this role for applications in the containers in the pods that use
this service account.}

\item{clientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{Metadata that assists with categorization and organization. Each tag
consists of a key and an optional value. You define both. Tags don't
propagate to any other cluster or Amazon Web Services resources.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource – 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length – 128 Unicode characters in UTF-8
\item Maximum value length – 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}
}
\description{
Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with \emph{EKS Pod Identity}. Use EKS Pod Identity to give temporary IAM credentials to pods and the credentials are rotated automatically.

See \url{https://www.paws-r-sdk.com/docs/eks_create_pod_identity_association/} for full documentation.
}
\keyword{internal}
