% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_snapshot}
\alias{ec2_create_snapshot}
\title{Creates a snapshot of an EBS volume and stores it in Amazon S3}
\usage{
ec2_create_snapshot(
  Description = NULL,
  OutpostArn = NULL,
  VolumeId,
  TagSpecifications = NULL,
  Location = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Description}{A description for the snapshot.}

\item{OutpostArn}{Only supported for volumes on Outposts. If the source volume is not on
an Outpost, omit this parameter.
\itemize{
\item To create the snapshot on the same Outpost as the source volume,
specify the ARN of that Outpost. The snapshot must be created on the
same Outpost as the volume.
\item To create the snapshot in the parent Region of the Outpost, omit
this parameter.
}

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot}{Create local snapshots from volumes on an Outpost}
in the \emph{Amazon EBS User Guide}.}

\item{VolumeId}{[required] The ID of the Amazon EBS volume.}

\item{TagSpecifications}{The tags to apply to the snapshot during creation.}

\item{Location}{Only supported for volumes in Local Zones. If the source volume is not
in a Local Zone, omit this parameter.
\itemize{
\item To create a local snapshot in the same Local Zone as the source
volume, specify \code{local}.
\item To create a regional snapshot in the parent Region of the Local
Zone, specify \code{regional} or omit this parameter.
}

Default value: \code{regional}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_snapshot/} for full documentation.
}
\keyword{internal}
