% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_ipam_pool}
\alias{ec2_modify_ipam_pool}
\title{Modify the configurations of an IPAM pool}
\usage{
ec2_modify_ipam_pool(
  DryRun = NULL,
  IpamPoolId,
  Description = NULL,
  AutoImport = NULL,
  AllocationMinNetmaskLength = NULL,
  AllocationMaxNetmaskLength = NULL,
  AllocationDefaultNetmaskLength = NULL,
  ClearAllocationDefaultNetmaskLength = NULL,
  AddAllocationResourceTags = NULL,
  RemoveAllocationResourceTags = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool you want to modify.}

\item{Description}{The description of the IPAM pool you want to modify.}

\item{AutoImport}{If true, IPAM will continuously look for resources within the CIDR range
of this pool and automatically import them as allocations into your
IPAM. The CIDRs that will be allocated for these resources must not
already be allocated to other resources in order for the import to
succeed. IPAM will import a CIDR regardless of its compliance with the
pool's allocation rules, so a resource might be imported and
subsequently marked as noncompliant. If IPAM discovers multiple CIDRs
that overlap, IPAM will import the largest CIDR only. If IPAM discovers
multiple CIDRs with matching CIDRs, IPAM will randomly import one of
them only.

A locale must be set on the pool for this feature to work.}

\item{AllocationMinNetmaskLength}{The minimum netmask length required for CIDR allocations in this IPAM
pool to be compliant. Possible netmask lengths for IPv4 addresses are
0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128. The
minimum netmask length must be less than the maximum netmask length.}

\item{AllocationMaxNetmaskLength}{The maximum netmask length possible for CIDR allocations in this IPAM
pool to be compliant. Possible netmask lengths for IPv4 addresses are
0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.The
maximum netmask length must be greater than the minimum netmask length.}

\item{AllocationDefaultNetmaskLength}{The default netmask length for allocations added to this pool. If, for
example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16
here, new allocations will default to 10.0.0.0/16.}

\item{ClearAllocationDefaultNetmaskLength}{Clear the default netmask length allocation rule for this pool.}

\item{AddAllocationResourceTags}{Add tag allocation rules to a pool. For more information about
allocation rules, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html}{Create a top-level pool}
in the \emph{Amazon VPC IPAM User Guide}.}

\item{RemoveAllocationResourceTags}{Remove tag allocation rules from a pool.}
}
\description{
Modify the configurations of an IPAM pool.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_ipam_pool/} for full documentation.
}
\keyword{internal}
