% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_block_offerings}
\alias{ec2_describe_capacity_block_offerings}
\title{Describes Capacity Block offerings available for purchase in the Amazon
Web Services Region that you're currently using}
\usage{
ec2_describe_capacity_block_offerings(
  DryRun = NULL,
  InstanceType,
  InstanceCount,
  StartDateRange = NULL,
  EndDateRange = NULL,
  CapacityDurationHours,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceType}{[required] The type of instance for which the Capacity Block offering reserves
capacity.}

\item{InstanceCount}{[required] The number of instances for which to reserve capacity.}

\item{StartDateRange}{The earliest start date for the Capacity Block offering.}

\item{EndDateRange}{The latest end date for the Capacity Block offering.}

\item{CapacityDurationHours}{[required] The number of hours for which to reserve Capacity Block.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes Capacity Block offerings available for purchase in the Amazon Web Services Region that you're currently using. With Capacity Blocks, you purchase a specific instance type for a period of time.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_offerings/} for full documentation.
}
\keyword{internal}
