% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_verified_access_endpoint}
\alias{ec2_create_verified_access_endpoint}
\title{An Amazon Web Services Verified Access endpoint is where you define your
application along with an optional endpoint-level access policy}
\usage{
ec2_create_verified_access_endpoint(
  VerifiedAccessGroupId,
  EndpointType,
  AttachmentType,
  DomainCertificateArn,
  ApplicationDomain,
  EndpointDomainPrefix,
  SecurityGroupIds = NULL,
  LoadBalancerOptions = NULL,
  NetworkInterfaceOptions = NULL,
  Description = NULL,
  PolicyDocument = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  SseSpecification = NULL
)
}
\arguments{
\item{VerifiedAccessGroupId}{[required] The ID of the Verified Access group to associate the endpoint with.}

\item{EndpointType}{[required] The type of Verified Access endpoint to create.}

\item{AttachmentType}{[required] The type of attachment.}

\item{DomainCertificateArn}{[required] The ARN of the public TLS/SSL certificate in Amazon Web Services
Certificate Manager to associate with the endpoint. The CN in the
certificate must match the DNS name your end users will use to reach
your application.}

\item{ApplicationDomain}{[required] The DNS name for users to reach your application.}

\item{EndpointDomainPrefix}{[required] A custom identifier that is prepended to the DNS name that is generated
for the endpoint.}

\item{SecurityGroupIds}{The IDs of the security groups to associate with the Verified Access
endpoint. Required if \code{AttachmentType} is set to \code{vpc}.}

\item{LoadBalancerOptions}{The load balancer details. This parameter is required if the endpoint
type is \code{load-balancer}.}

\item{NetworkInterfaceOptions}{The network interface details. This parameter is required if the
endpoint type is \code{network-interface}.}

\item{Description}{A description for the Verified Access endpoint.}

\item{PolicyDocument}{The Verified Access policy document.}

\item{TagSpecifications}{The tags to assign to the Verified Access endpoint.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SseSpecification}{The options for server side encryption.}
}
\description{
An Amazon Web Services Verified Access endpoint is where you define your application along with an optional endpoint-level access policy.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_verified_access_endpoint/} for full documentation.
}
\keyword{internal}
