% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_export_license_recommendations}
\alias{computeoptimizer_export_license_recommendations}
\title{Export optimization recommendations for your licenses}
\usage{
computeoptimizer_export_license_recommendations(
  accountIds = NULL,
  filters = NULL,
  fieldsToExport = NULL,
  s3DestinationConfig,
  fileFormat = NULL,
  includeMemberAccounts = NULL
)
}
\arguments{
\item{accountIds}{The IDs of the Amazon Web Services accounts for which to export license
recommendations.

If your account is the management account of an organization, use this
parameter to specify the member account for which you want to export
recommendations.

This parameter can't be specified together with the include member
accounts parameter. The parameters are mutually exclusive.

If this parameter is omitted, recommendations for member accounts aren't
included in the export.

You can specify multiple account IDs per request.}

\item{filters}{An array of objects to specify a filter that exports a more specific set
of license recommendations.}

\item{fieldsToExport}{The recommendations data to include in the export file. For more
information about the fields that can be exported, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files}{Exported files}
in the \emph{Compute Optimizer User Guide}.}

\item{s3DestinationConfig}{[required]}

\item{fileFormat}{The format of the export file.

A CSV file is the only export format currently supported.}

\item{includeMemberAccounts}{Indicates whether to include recommendations for resources in all member
accounts of the organization if your account is the management account
of an organization.

The member accounts must also be opted in to Compute Optimizer, and
trusted access for Compute Optimizer must be enabled in the organization
account. For more information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access}{Compute Optimizer and Amazon Web Services Organizations trusted access}
in the \emph{Compute Optimizer User Guide}.

If this parameter is omitted, recommendations for member accounts of the
organization aren't included in the export file .

This parameter cannot be specified together with the account IDs
parameter. The parameters are mutually exclusive.}
}
\description{
Export optimization recommendations for your licenses.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_export_license_recommendations/} for full documentation.
}
\keyword{internal}
