% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_ipam_resource_cidr}
\alias{ec2_modify_ipam_resource_cidr}
\title{Modify a resource CIDR}
\usage{
ec2_modify_ipam_resource_cidr(
  DryRun = NULL,
  ResourceId,
  ResourceCidr,
  ResourceRegion,
  CurrentIpamScopeId,
  DestinationIpamScopeId = NULL,
  Monitored
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{ResourceId}{[required] The ID of the resource you want to modify.}

\item{ResourceCidr}{[required] The CIDR of the resource you want to modify.}

\item{ResourceRegion}{[required] The Amazon Web Services Region of the resource you want to modify.}

\item{CurrentIpamScopeId}{[required] The ID of the current scope that the resource CIDR is in.}

\item{DestinationIpamScopeId}{The ID of the scope you want to transfer the resource CIDR to.}

\item{Monitored}{[required] Determines if the resource is monitored by IPAM. If a resource is
monitored, the resource is discovered by IPAM and you can view details
about the resource’s CIDR.}
}
\description{
Modify a resource CIDR. You can use this action to transfer resource CIDRs between scopes and ignore resource CIDRs that you do not want to manage. If set to false, the resource will not be tracked for overlap, it cannot be auto-imported into a pool, and it will be removed from any pool it has an allocation in.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_ipam_resource_cidr/} for full documentation.
}
\keyword{internal}
