% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_client_vpn_endpoint}
\alias{ec2_create_client_vpn_endpoint}
\title{Creates a Client VPN endpoint}
\usage{
ec2_create_client_vpn_endpoint(
  ClientCidrBlock,
  ServerCertificateArn,
  AuthenticationOptions,
  ConnectionLogOptions,
  DnsServers = NULL,
  TransportProtocol = NULL,
  VpnPort = NULL,
  Description = NULL,
  SplitTunnel = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  TagSpecifications = NULL,
  SecurityGroupIds = NULL,
  VpcId = NULL,
  SelfServicePortal = NULL,
  ClientConnectOptions = NULL,
  SessionTimeoutHours = NULL,
  ClientLoginBannerOptions = NULL
)
}
\arguments{
\item{ClientCidrBlock}{[required] The IPv4 address range, in CIDR notation, from which to assign client IP
addresses. The address range cannot overlap with the local CIDR of the
VPC in which the associated subnet is located, or the routes that you
add manually. The address range cannot be changed after the Client VPN
endpoint has been created. Client CIDR range must have a size of at
least /22 and must not be greater than /12.}

\item{ServerCertificateArn}{[required] The ARN of the server certificate. For more information, see the
\href{https://docs.aws.amazon.com/acm/latest/userguide/}{Certificate Manager User Guide}.}

\item{AuthenticationOptions}{[required] Information about the authentication method to be used to authenticate
clients.}

\item{ConnectionLogOptions}{[required] Information about the client connection logging options.

If you enable client connection logging, data about client connections
is sent to a Cloudwatch Logs log stream. The following information is
logged:
\itemize{
\item Client connection requests
\item Client connection results (successful and unsuccessful)
\item Reasons for unsuccessful client connection requests
\item Client connection termination time
}}

\item{DnsServers}{Information about the DNS servers to be used for DNS resolution. A
Client VPN endpoint can have up to two DNS servers. If no DNS server is
specified, the DNS address configured on the device is used for the DNS
server.}

\item{TransportProtocol}{The transport protocol to be used by the VPN session.

Default value: \code{udp}}

\item{VpnPort}{The port number to assign to the Client VPN endpoint for TCP and UDP
traffic.

Valid Values: \code{443} | \code{1194}

Default Value: \code{443}}

\item{Description}{A brief description of the Client VPN endpoint.}

\item{SplitTunnel}{Indicates whether split-tunnel is enabled on the Client VPN endpoint.

By default, split-tunnel on a VPN endpoint is disabled.

For information about split-tunnel VPN endpoints, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html}{Split-tunnel Client VPN endpoint}
in the \emph{Client VPN Administrator Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}

\item{TagSpecifications}{The tags to apply to the Client VPN endpoint during creation.}

\item{SecurityGroupIds}{The IDs of one or more security groups to apply to the target network.
You must also specify the ID of the VPC that contains the security
groups.}

\item{VpcId}{The ID of the VPC to associate with the Client VPN endpoint. If no
security group IDs are specified in the request, the default security
group for the VPC is applied.}

\item{SelfServicePortal}{Specify whether to enable the self-service portal for the Client VPN
endpoint.

Default Value: \code{enabled}}

\item{ClientConnectOptions}{The options for managing connection authorization for new client
connections.}

\item{SessionTimeoutHours}{The maximum VPN session duration time in hours.

Valid values: \code{8 | 10 | 12 | 24}

Default value: \code{24}}

\item{ClientLoginBannerOptions}{Options for enabling a customizable text banner that will be displayed
on Amazon Web Services provided clients when a VPN session is
established.}
}
\description{
Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_client_vpn_endpoint/} for full documentation.
}
\keyword{internal}
