% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_describe_pull_through_cache_rules}
\alias{ecr_describe_pull_through_cache_rules}
\title{Returns the pull through cache rules for a registry}
\usage{
ecr_describe_pull_through_cache_rules(
  registryId = NULL,
  ecrRepositoryPrefixes = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry to
return the pull through cache rules for. If you do not specify a
registry, the default registry is assumed.}

\item{ecrRepositoryPrefixes}{The Amazon ECR repository prefixes associated with the pull through
cache rules to return. If no repository prefix value is specified, all
pull through cache rules are returned.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{DescribePullThroughCacheRulesRequest} request where \code{maxResults} was
used and the results exceeded the value of that parameter. Pagination
continues from the end of the previous results that returned the
\code{nextToken} value. This value is null when there are no more results to
return.}

\item{maxResults}{The maximum number of pull through cache rules returned by
\code{DescribePullThroughCacheRulesRequest} in paginated output. When this
parameter is used, \code{DescribePullThroughCacheRulesRequest} only returns
\code{maxResults} results in a single page along with a \code{nextToken} response
element. The remaining results of the initial request can be seen by
sending another \code{DescribePullThroughCacheRulesRequest} request with the
returned \code{nextToken} value. This value can be between 1 and 1000. If
this parameter is not used, then \code{DescribePullThroughCacheRulesRequest}
returns up to 100 results and a \code{nextToken} value, if applicable.}
}
\description{
Returns the pull through cache rules for a registry.

See \url{https://www.paws-r-sdk.com/docs/ecr_describe_pull_through_cache_rules/} for full documentation.
}
\keyword{internal}
