% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_discovered_resource_cidrs}
\alias{ec2_get_ipam_discovered_resource_cidrs}
\title{Returns the resource CIDRs that are monitored as part of a resource
discovery}
\usage{
ec2_get_ipam_discovered_resource_cidrs(
  DryRun = NULL,
  IpamResourceDiscoveryId,
  ResourceRegion,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamResourceDiscoveryId}{[required] A resource discovery ID.}

\item{ResourceRegion}{[required] A resource Region.}

\item{Filters}{Filters.}

\item{NextToken}{Specify the pagination token from a previous request to retrieve the
next page of results.}

\item{MaxResults}{The maximum number of discovered resource CIDRs to return in one page of
results.}
}
\description{
Returns the resource CIDRs that are monitored as part of a resource discovery. A discovered resource is a resource CIDR monitored under a resource discovery. The following resources can be discovered: VPCs, Public IPv4 pools, VPC subnets, and Elastic IP addresses.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_ipam_discovered_resource_cidrs/} for full documentation.
}
\keyword{internal}
