% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_flow_logs}
\alias{ec2_describe_flow_logs}
\title{Describes one or more flow logs}
\usage{
ec2_describe_flow_logs(
  DryRun = NULL,
  Filter = NULL,
  FlowLogIds = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filter}{One or more filters.
\itemize{
\item \code{deliver-log-status} - The status of the logs delivery (\code{SUCCESS} |
\code{FAILED}).
\item \code{log-destination-type} - The type of destination for the flow log
data (\code{cloud-watch-logs} | \code{s3} | \code{kinesis-data-firehose}).
\item \code{flow-log-id} - The ID of the flow log.
\item \code{log-group-name} - The name of the log group.
\item \code{resource-id} - The ID of the VPC, subnet, or network interface.
\item \code{traffic-type} - The type of traffic (\code{ACCEPT} | \code{REJECT} | \code{ALL}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{FlowLogIds}{One or more flow log IDs.

Constraint: Maximum of 1000 flow log IDs.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token to request the next page of items. Pagination continues from
the end of the items returned by the previous request.}
}
\description{
Describes one or more flow logs.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_flow_logs/} for full documentation.
}
\keyword{internal}
