% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_runtime_management_config}
\alias{lambda_put_runtime_management_config}
\title{Sets the runtime management configuration for a function's version}
\usage{
lambda_put_runtime_management_config(
  FunctionName,
  Qualifier = NULL,
  UpdateRuntimeOn,
  RuntimeVersionArn = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version of the function. This can be \verb{$LATEST} or a published
version number. If no value is specified, the configuration for the
\verb{$LATEST} version is returned.}

\item{UpdateRuntimeOn}{[required] Specify the runtime update mode.
\itemize{
\item \strong{Auto (default)} - Automatically update to the most recent and
secure runtime version using a \href{https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase}{Two-phase runtime version rollout}.
This is the best choice for most customers to ensure they always
benefit from runtime updates.
\item \strong{Function update} - Lambda updates the runtime of your function to
the most recent and secure runtime version when you update your
function. This approach synchronizes runtime updates with function
deployments, giving you control over when runtime updates are
applied and allowing you to detect and mitigate rare runtime update
incompatibilities early. When using this setting, you need to
regularly update your functions to keep their runtime up-to-date.
\item \strong{Manual} - You specify a runtime version in your function
configuration. The function will use this runtime version
indefinitely. In the rare case where a new runtime version is
incompatible with an existing function, this allows you to roll back
your function to an earlier runtime version. For more information,
see \href{https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback}{Roll back a runtime version}.
}}

\item{RuntimeVersionArn}{The ARN of the runtime version you want the function to use.

This is only required if you're using the \strong{Manual} runtime update
mode.}
}
\description{
Sets the runtime management configuration for a function's version. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html}{Runtime updates}.

See \url{https://www.paws-r-sdk.com/docs/lambda_put_runtime_management_config/} for full documentation.
}
\keyword{internal}
