% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_tags}
\alias{ec2_describe_tags}
\title{Describes the specified tags for your EC2 resources}
\usage{
ec2_describe_tags(
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{key} - The tag key.
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The resource type (\code{customer-gateway} |
\code{dedicated-host} | \code{dhcp-options} | \code{elastic-ip} | \code{fleet} |
\code{fpga-image} | \code{host-reservation} | \code{image} | \code{instance} |
\code{internet-gateway} | \code{key-pair} | \code{launch-template} | \code{natgateway} |
\code{network-acl} | \code{network-interface} | \code{placement-group} |
\code{reserved-instances} | \code{route-table} | \code{security-group} | \code{snapshot}
| \code{spot-instances-request} | \code{subnet} | \code{volume} | \code{vpc} |
\code{vpc-endpoint} | \code{vpc-endpoint-service} | \code{vpc-peering-connection} |
\code{vpn-connection} | \code{vpn-gateway}).
\item \code{tag}:\<key\> - The key/value combination of the tag. For example,
specify "tag:Owner" for the filter name and "TeamA" for the filter
value to find resources with the tag "Owner=TeamA".
\item \code{value} - The tag value.
}}

\item{MaxResults}{The maximum number of items to return for this request. This value can
be between 5 and 1000. To get the next page of items, make another
request with the token returned in the output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}
}
\description{
Describes the specified tags for your EC2 resources.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_tags/} for full documentation.
}
\keyword{internal}
