% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_network_interface}
\alias{ec2_create_network_interface}
\title{Creates a network interface in the specified subnet}
\usage{
ec2_create_network_interface(
  Description = NULL,
  DryRun = NULL,
  Groups = NULL,
  Ipv6AddressCount = NULL,
  Ipv6Addresses = NULL,
  PrivateIpAddress = NULL,
  PrivateIpAddresses = NULL,
  SecondaryPrivateIpAddressCount = NULL,
  Ipv4Prefixes = NULL,
  Ipv4PrefixCount = NULL,
  Ipv6Prefixes = NULL,
  Ipv6PrefixCount = NULL,
  InterfaceType = NULL,
  SubnetId,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{Description}{A description for the network interface.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Groups}{The IDs of one or more security groups.}

\item{Ipv6AddressCount}{The number of IPv6 addresses to assign to a network interface. Amazon
EC2 automatically selects the IPv6 addresses from the subnet range.

You can't specify a count of IPv6 addresses using this parameter if
you've specified one of the following: specific IPv6 addresses, specific
IPv6 prefixes, or a count of IPv6 prefixes.

If your subnet has the \code{AssignIpv6AddressOnCreation} attribute set, you
can override that setting by specifying 0 as the IPv6 address count.}

\item{Ipv6Addresses}{The IPv6 addresses from the IPv6 CIDR block range of your subnet.

You can't specify IPv6 addresses using this parameter if you've
specified one of the following: a count of IPv6 addresses, specific IPv6
prefixes, or a count of IPv6 prefixes.}

\item{PrivateIpAddress}{The primary private IPv4 address of the network interface. If you don't
specify an IPv4 address, Amazon EC2 selects one for you from the
subnet's IPv4 CIDR range. If you specify an IP address, you cannot
indicate any IP addresses specified in \code{privateIpAddresses} as primary
(only one IP address can be designated as primary).}

\item{PrivateIpAddresses}{The private IPv4 addresses.

You can't specify private IPv4 addresses if you've specified one of the
following: a count of private IPv4 addresses, specific IPv4 prefixes, or
a count of IPv4 prefixes.}

\item{SecondaryPrivateIpAddressCount}{The number of secondary private IPv4 addresses to assign to a network
interface. When you specify a number of secondary IPv4 addresses, Amazon
EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You
can't specify this option and specify more than one private IP address
using \code{privateIpAddresses}.

You can't specify a count of private IPv4 addresses if you've specified
one of the following: specific private IPv4 addresses, specific IPv4
prefixes, or a count of IPv4 prefixes.}

\item{Ipv4Prefixes}{The IPv4 prefixes assigned to the network interface.

You can't specify IPv4 prefixes if you've specified one of the
following: a count of IPv4 prefixes, specific private IPv4 addresses, or
a count of private IPv4 addresses.}

\item{Ipv4PrefixCount}{The number of IPv4 prefixes that Amazon Web Services automatically
assigns to the network interface.

You can't specify a count of IPv4 prefixes if you've specified one of
the following: specific IPv4 prefixes, specific private IPv4 addresses,
or a count of private IPv4 addresses.}

\item{Ipv6Prefixes}{The IPv6 prefixes assigned to the network interface.

You can't specify IPv6 prefixes if you've specified one of the
following: a count of IPv6 prefixes, specific IPv6 addresses, or a count
of IPv6 addresses.}

\item{Ipv6PrefixCount}{The number of IPv6 prefixes that Amazon Web Services automatically
assigns to the network interface.

You can't specify a count of IPv6 prefixes if you've specified one of
the following: specific IPv6 prefixes, specific IPv6 addresses, or a
count of IPv6 addresses.}

\item{InterfaceType}{The type of network interface. The default is \code{interface}.

The only supported values are \code{interface}, \code{efa}, and \code{trunk}.}

\item{SubnetId}{[required] The ID of the subnet to associate with the network interface.}

\item{TagSpecifications}{The tags to apply to the new network interface.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}
}
\description{
Creates a network interface in the specified subnet.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_network_interface/} for full documentation.
}
\keyword{internal}
