% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_nat_gateway_address}
\alias{ec2_associate_nat_gateway_address}
\title{Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a
public NAT gateway}
\usage{
ec2_associate_nat_gateway_address(
  NatGatewayId,
  AllocationIds,
  PrivateIpAddresses = NULL,
  DryRun = NULL
)
}
\arguments{
\item{NatGatewayId}{[required] The NAT gateway ID.}

\item{AllocationIds}{[required] The allocation IDs of EIPs that you want to associate with your NAT
gateway.}

\item{PrivateIpAddresses}{The private IPv4 addresses that you want to assign to the NAT gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with}{Work with NAT gateways} in the \emph{Amazon Virtual Private Cloud User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_associate_nat_gateway_address/} for full documentation.
}
\keyword{internal}
