# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include braket_service.R
NULL

#' Cancels an Amazon Braket job
#'
#' @description
#' Cancels an Amazon Braket job.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_cancel_job/](https://www.paws-r-sdk.com/docs/braket_cancel_job/) for full documentation.
#'
#' @param jobArn &#91;required&#93; The ARN of the Amazon Braket job to cancel.
#'
#' @keywords internal
#'
#' @rdname braket_cancel_job
braket_cancel_job <- function(jobArn) {
  op <- new_operation(
    name = "CancelJob",
    http_method = "PUT",
    http_path = "/job/{jobArn}/cancel",
    paginator = list()
  )
  input <- .braket$cancel_job_input(jobArn = jobArn)
  output <- .braket$cancel_job_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$cancel_job <- braket_cancel_job

#' Cancels the specified task
#'
#' @description
#' Cancels the specified task.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_cancel_quantum_task/](https://www.paws-r-sdk.com/docs/braket_cancel_quantum_task/) for full documentation.
#'
#' @param clientToken &#91;required&#93; The client token associated with the request.
#' @param quantumTaskArn &#91;required&#93; The ARN of the task to cancel.
#'
#' @keywords internal
#'
#' @rdname braket_cancel_quantum_task
braket_cancel_quantum_task <- function(clientToken, quantumTaskArn) {
  op <- new_operation(
    name = "CancelQuantumTask",
    http_method = "PUT",
    http_path = "/quantum-task/{quantumTaskArn}/cancel",
    paginator = list()
  )
  input <- .braket$cancel_quantum_task_input(clientToken = clientToken, quantumTaskArn = quantumTaskArn)
  output <- .braket$cancel_quantum_task_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$cancel_quantum_task <- braket_cancel_quantum_task

#' Creates an Amazon Braket job
#'
#' @description
#' Creates an Amazon Braket job.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_create_job/](https://www.paws-r-sdk.com/docs/braket_create_job/) for full documentation.
#'
#' @param algorithmSpecification &#91;required&#93; Definition of the Amazon Braket job to be created. Specifies the
#' container image the job uses and information about the Python scripts
#' used for entry and training.
#' @param checkpointConfig Information about the output locations for job checkpoint data.
#' @param clientToken &#91;required&#93; A unique token that guarantees that the call to this API is idempotent.
#' @param deviceConfig &#91;required&#93; The quantum processing unit (QPU) or simulator used to create an Amazon
#' Braket job.
#' @param hyperParameters Algorithm-specific parameters used by an Amazon Braket job that
#' influence the quality of the training job. The values are set with a
#' string of JSON key:value pairs, where the key is the name of the
#' hyperparameter and the value is the value of th hyperparameter.
#' @param inputDataConfig A list of parameters that specify the name and type of input data and
#' where it is located.
#' @param instanceConfig &#91;required&#93; Configuration of the resource instances to use while running the hybrid
#' job on Amazon Braket.
#' @param jobName &#91;required&#93; The name of the Amazon Braket job.
#' @param outputDataConfig &#91;required&#93; The path to the S3 location where you want to store job artifacts and
#' the encryption key used to store them.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can
#' assume to perform tasks on behalf of a user. It can access user
#' resources, run an Amazon Braket job container on behalf of user, and
#' output resources to the users' s3 buckets.
#' @param stoppingCondition The user-defined criteria that specifies when a job stops running.
#' @param tags A tag object that consists of a key and an optional value, used to
#' manage metadata for Amazon Braket resources.
#'
#' @keywords internal
#'
#' @rdname braket_create_job
braket_create_job <- function(algorithmSpecification, checkpointConfig = NULL, clientToken, deviceConfig, hyperParameters = NULL, inputDataConfig = NULL, instanceConfig, jobName, outputDataConfig, roleArn, stoppingCondition = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/job",
    paginator = list()
  )
  input <- .braket$create_job_input(algorithmSpecification = algorithmSpecification, checkpointConfig = checkpointConfig, clientToken = clientToken, deviceConfig = deviceConfig, hyperParameters = hyperParameters, inputDataConfig = inputDataConfig, instanceConfig = instanceConfig, jobName = jobName, outputDataConfig = outputDataConfig, roleArn = roleArn, stoppingCondition = stoppingCondition, tags = tags)
  output <- .braket$create_job_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$create_job <- braket_create_job

#' Creates a quantum task
#'
#' @description
#' Creates a quantum task.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_create_quantum_task/](https://www.paws-r-sdk.com/docs/braket_create_quantum_task/) for full documentation.
#'
#' @param action &#91;required&#93; The action associated with the task.
#' @param clientToken &#91;required&#93; The client token associated with the request.
#' @param deviceArn &#91;required&#93; The ARN of the device to run the task on.
#' @param deviceParameters The parameters for the device to run the task on.
#' @param jobToken The token for an Amazon Braket job that associates it with the quantum
#' task.
#' @param outputS3Bucket &#91;required&#93; The S3 bucket to store task result files in.
#' @param outputS3KeyPrefix &#91;required&#93; The key prefix for the location in the S3 bucket to store task results
#' in.
#' @param shots &#91;required&#93; The number of shots to use for the task.
#' @param tags Tags to be added to the quantum task you're creating.
#'
#' @keywords internal
#'
#' @rdname braket_create_quantum_task
braket_create_quantum_task <- function(action, clientToken, deviceArn, deviceParameters = NULL, jobToken = NULL, outputS3Bucket, outputS3KeyPrefix, shots, tags = NULL) {
  op <- new_operation(
    name = "CreateQuantumTask",
    http_method = "POST",
    http_path = "/quantum-task",
    paginator = list()
  )
  input <- .braket$create_quantum_task_input(action = action, clientToken = clientToken, deviceArn = deviceArn, deviceParameters = deviceParameters, jobToken = jobToken, outputS3Bucket = outputS3Bucket, outputS3KeyPrefix = outputS3KeyPrefix, shots = shots, tags = tags)
  output <- .braket$create_quantum_task_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$create_quantum_task <- braket_create_quantum_task

#' Retrieves the devices available in Amazon Braket
#'
#' @description
#' Retrieves the devices available in Amazon Braket.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_get_device/](https://www.paws-r-sdk.com/docs/braket_get_device/) for full documentation.
#'
#' @param deviceArn &#91;required&#93; The ARN of the device to retrieve.
#'
#' @keywords internal
#'
#' @rdname braket_get_device
braket_get_device <- function(deviceArn) {
  op <- new_operation(
    name = "GetDevice",
    http_method = "GET",
    http_path = "/device/{deviceArn}",
    paginator = list()
  )
  input <- .braket$get_device_input(deviceArn = deviceArn)
  output <- .braket$get_device_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$get_device <- braket_get_device

#' Retrieves the specified Amazon Braket job
#'
#' @description
#' Retrieves the specified Amazon Braket job.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_get_job/](https://www.paws-r-sdk.com/docs/braket_get_job/) for full documentation.
#'
#' @param jobArn &#91;required&#93; The ARN of the job to retrieve.
#'
#' @keywords internal
#'
#' @rdname braket_get_job
braket_get_job <- function(jobArn) {
  op <- new_operation(
    name = "GetJob",
    http_method = "GET",
    http_path = "/job/{jobArn}",
    paginator = list()
  )
  input <- .braket$get_job_input(jobArn = jobArn)
  output <- .braket$get_job_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$get_job <- braket_get_job

#' Retrieves the specified quantum task
#'
#' @description
#' Retrieves the specified quantum task.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_get_quantum_task/](https://www.paws-r-sdk.com/docs/braket_get_quantum_task/) for full documentation.
#'
#' @param quantumTaskArn &#91;required&#93; the ARN of the task to retrieve.
#'
#' @keywords internal
#'
#' @rdname braket_get_quantum_task
braket_get_quantum_task <- function(quantumTaskArn) {
  op <- new_operation(
    name = "GetQuantumTask",
    http_method = "GET",
    http_path = "/quantum-task/{quantumTaskArn}",
    paginator = list()
  )
  input <- .braket$get_quantum_task_input(quantumTaskArn = quantumTaskArn)
  output <- .braket$get_quantum_task_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$get_quantum_task <- braket_get_quantum_task

#' Shows the tags associated with this resource
#'
#' @description
#' Shows the tags associated with this resource.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/braket_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Specify the `resourceArn` for the resource whose tags to display.
#'
#' @keywords internal
#'
#' @rdname braket_list_tags_for_resource
braket_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .braket$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .braket$list_tags_for_resource_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$list_tags_for_resource <- braket_list_tags_for_resource

#' Searches for devices using the specified filters
#'
#' @description
#' Searches for devices using the specified filters.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_search_devices/](https://www.paws-r-sdk.com/docs/braket_search_devices/) for full documentation.
#'
#' @param filters &#91;required&#93; The filter values to use to search for a device.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned in the response. Use the
#' token returned from the previous request continue results where the
#' previous request ended.
#'
#' @keywords internal
#'
#' @rdname braket_search_devices
braket_search_devices <- function(filters, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "SearchDevices",
    http_method = "POST",
    http_path = "/devices",
    paginator = list()
  )
  input <- .braket$search_devices_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .braket$search_devices_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$search_devices <- braket_search_devices

#' Searches for Amazon Braket jobs that match the specified filter values
#'
#' @description
#' Searches for Amazon Braket jobs that match the specified filter values.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_search_jobs/](https://www.paws-r-sdk.com/docs/braket_search_jobs/) for full documentation.
#'
#' @param filters &#91;required&#93; The filter values to use when searching for a job.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned in the response. Use the
#' token returned from the previous request to continue results where the
#' previous request ended.
#'
#' @keywords internal
#'
#' @rdname braket_search_jobs
braket_search_jobs <- function(filters, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "SearchJobs",
    http_method = "POST",
    http_path = "/jobs",
    paginator = list()
  )
  input <- .braket$search_jobs_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .braket$search_jobs_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$search_jobs <- braket_search_jobs

#' Searches for tasks that match the specified filter values
#'
#' @description
#' Searches for tasks that match the specified filter values.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_search_quantum_tasks/](https://www.paws-r-sdk.com/docs/braket_search_quantum_tasks/) for full documentation.
#'
#' @param filters &#91;required&#93; Array of `SearchQuantumTasksFilter` objects.
#' @param maxResults Maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned in the response. Use the
#' token returned from the previous request continue results where the
#' previous request ended.
#'
#' @keywords internal
#'
#' @rdname braket_search_quantum_tasks
braket_search_quantum_tasks <- function(filters, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "SearchQuantumTasks",
    http_method = "POST",
    http_path = "/quantum-tasks",
    paginator = list()
  )
  input <- .braket$search_quantum_tasks_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .braket$search_quantum_tasks_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$search_quantum_tasks <- braket_search_quantum_tasks

#' Add a tag to the specified resource
#'
#' @description
#' Add a tag to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_tag_resource/](https://www.paws-r-sdk.com/docs/braket_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Specify the `resourceArn` of the resource to which a tag will be added.
#' @param tags &#91;required&#93; Specify the tags to add to the resource.
#'
#' @keywords internal
#'
#' @rdname braket_tag_resource
braket_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .braket$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .braket$tag_resource_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$tag_resource <- braket_tag_resource

#' Remove tags from a resource
#'
#' @description
#' Remove tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/braket_untag_resource/](https://www.paws-r-sdk.com/docs/braket_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Specify the `resourceArn` for the resource from which to remove the
#' tags.
#' @param tagKeys &#91;required&#93; Specify the keys for the tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname braket_untag_resource
braket_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .braket$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .braket$untag_resource_output()
  config <- get_config()
  svc <- .braket$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.braket$operations$untag_resource <- braket_untag_resource
