% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_identity_provider_configs}
\alias{eks_list_identity_provider_configs}
\title{A list of identity provider configurations}
\usage{
eks_list_identity_provider_configs(
  clusterName,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The cluster name that you want to list identity provider configurations
for.}

\item{maxResults}{The maximum number of identity provider configurations returned by
\code{\link[=eks_list_identity_provider_configs]{list_identity_provider_configs}}
in paginated output. When you use this parameter,
\code{\link[=eks_list_identity_provider_configs]{list_identity_provider_configs}}
returns only \code{maxResults} results in a single page along with a
\code{nextToken} response element. You can see the remaining results of the
initial request by sending another
\code{\link[=eks_list_identity_provider_configs]{list_identity_provider_configs}}
request with the returned \code{nextToken} value. This value can be between 1
and 100. If you don't use this parameter,
\code{\link[=eks_list_identity_provider_configs]{list_identity_provider_configs}}
returns up to 100 results and a \code{nextToken} value, if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{IdentityProviderConfigsRequest} where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.}
}
\description{
A list of identity provider configurations.

See \url{https://paws-r.github.io/docs/eks/list_identity_provider_configs.html} for full documentation.
}
\keyword{internal}
