% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_account_setting_default}
\alias{ecs_put_account_setting_default}
\title{Modifies an account setting for all IAM users on an account for whom no
individual account setting has been specified}
\usage{
ecs_put_account_setting_default(name, value)
}
\arguments{
\item{name}{[required] The resource name for which to modify the account setting. If
\code{serviceLongArnFormat} is specified, the ARN for your Amazon ECS
services is affected. If \code{taskLongArnFormat} is specified, the ARN and
resource ID for your Amazon ECS tasks is affected. If
\code{containerInstanceLongArnFormat} is specified, the ARN and resource ID
for your Amazon ECS container instances is affected. If \code{awsvpcTrunking}
is specified, the ENI limit for your Amazon ECS container instances is
affected. If \code{containerInsights} is specified, the default setting for
CloudWatch Container Insights for your clusters is affected.}

\item{value}{[required] The account setting value for the specified principal ARN. Accepted
values are \code{enabled} and \code{disabled}.}
}
\description{
Modifies an account setting for all IAM users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.

See \url{https://paws-r.github.io/docs/ecs/put_account_setting_default.html} for full documentation.
}
\keyword{internal}
