% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2instanceconnect_operations.R
\name{ec2instanceconnect_send_serial_console_ssh_public_key}
\alias{ec2instanceconnect_send_serial_console_ssh_public_key}
\title{Pushes an SSH public key to the specified EC2 instance}
\usage{
ec2instanceconnect_send_serial_console_ssh_public_key(
  InstanceId,
  SerialPort = NULL,
  SSHPublicKey
)
}
\arguments{
\item{InstanceId}{[required] The ID of the EC2 instance.}

\item{SerialPort}{The serial port of the EC2 instance. Currently only port 0 is supported.

Default: 0}

\item{SSHPublicKey}{[required] The public key material. To use the public key, you must have the
matching private key. For information about the supported key formats
and lengths, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws}{Requirements for key pairs}
in the \emph{Amazon EC2 User Guide}.}
}
\description{
Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60 seconds to establish a serial console connection to the instance using SSH. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-serial-console.html}{EC2 Serial Console} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/ec2instanceconnect/send_serial_console_ssh_public_key.html} for full documentation.
}
\keyword{internal}
