% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_image_attribute}
\alias{ec2_modify_image_attribute}
\title{Modifies the specified attribute of the specified AMI}
\usage{
ec2_modify_image_attribute(
  Attribute = NULL,
  Description = NULL,
  ImageId,
  LaunchPermission = NULL,
  OperationType = NULL,
  ProductCodes = NULL,
  UserGroups = NULL,
  UserIds = NULL,
  Value = NULL,
  DryRun = NULL,
  OrganizationArns = NULL,
  OrganizationalUnitArns = NULL
)
}
\arguments{
\item{Attribute}{The name of the attribute to modify.

Valid values: \code{description} | \code{launchPermission}}

\item{Description}{A new description for the AMI.}

\item{ImageId}{[required] The ID of the AMI.}

\item{LaunchPermission}{A new launch permission for the AMI.}

\item{OperationType}{The operation type. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{ProductCodes}{Not supported.}

\item{UserGroups}{The user groups. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{UserIds}{The Amazon Web Services account IDs. This parameter can be used only
when the \code{Attribute} parameter is \code{launchPermission}.}

\item{Value}{The value of the attribute being modified. This parameter can be used
only when the \code{Attribute} parameter is \code{description}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{OrganizationArns}{The Amazon Resource Name (ARN) of an organization. This parameter can be
used only when the \code{Attribute} parameter is \code{launchPermission}.}

\item{OrganizationalUnitArns}{The Amazon Resource Name (ARN) of an organizational unit (OU). This
parameter can be used only when the \code{Attribute} parameter is
\code{launchPermission}.}
}
\description{
Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use the \code{Attribute} parameter to specify the attribute or one of the following parameters: \code{Description} or \code{LaunchPermission}.

See \url{https://paws-r.github.io/docs/ec2/modify_image_attribute.html} for full documentation.
}
\keyword{internal}
