% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_pool_allocations}
\alias{ec2_get_ipam_pool_allocations}
\title{Get a list of all the CIDR allocations in an IPAM pool}
\usage{
ec2_get_ipam_pool_allocations(
  DryRun = NULL,
  IpamPoolId,
  IpamPoolAllocationId = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool you want to see the allocations for.}

\item{IpamPoolAllocationId}{The ID of the allocation.}

\item{Filters}{One or more filters for the request. For more information about
filtering, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{Filtering CLI output}.}

\item{MaxResults}{The maximum number of results you would like returned per page.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Get a list of all the CIDR allocations in an IPAM pool.

See \url{https://paws-r.github.io/docs/ec2/get_ipam_pool_allocations.html} for full documentation.
}
\keyword{internal}
