% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_instance_types_from_instance_requirements}
\alias{ec2_get_instance_types_from_instance_requirements}
\title{Returns a list of instance types with the specified instance attributes}
\usage{
ec2_get_instance_types_from_instance_requirements(
  DryRun = NULL,
  ArchitectureTypes,
  VirtualizationTypes,
  InstanceRequirements,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ArchitectureTypes}{[required] The processor architecture type.}

\item{VirtualizationTypes}{[required] The virtualization type.}

\item{InstanceRequirements}{[required] The attributes required for the instance types.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}
}
\description{
Returns a list of instance types with the specified instance attributes. You can use the response to preview the instance types without launching instances. Note that the response does not consider capacity.

See \url{https://paws-r.github.io/docs/ec2/get_instance_types_from_instance_requirements.html} for full documentation.
}
\keyword{internal}
